/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import com.aicas.jamaica.eclipse.ui.TargetRemoteExecutionTab;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TelnetComposite
extends RemoteExecutionType {
    public static String ATTR_PORT = "telnetPort";
    public static String ATTR_LOAD_COMMAND = "telnetLoadCommand";
    public static String ATTR_DELETE_ON_EXIT = "telnetDeleteOnExit";
    public static String ATTR_INTERACTIVE = "telnetInteractive";
    public static String ATTR_INTERACTIVE_AUTOLOGIN = "telnetInteractiveAutoLogin";
    private ArrayList controls = new ArrayList();
    private TargetRemoteExecutionTab targetRemoteExecutionTab;
    private Button typeSelection;
    private Text port;
    private Label portLabel;
    private Text loadCommand;
    private Label loadCommandLabel;
    private Button deleteOnExit;
    private Button verbose;
    private Button interactive;
    private Button autoLogin;

    public TelnetComposite(TargetRemoteExecutionTab parentTab) {
        this.targetRemoteExecutionTab = parentTab;
    }

    public Composite createControl(Composite comp) {
        this.typeSelection = new Button(comp, 16);
        this.typeSelection.setText(this.getTypeTitle());
        try {
            FontData fd = this.typeSelection.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.typeSelection.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.typeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TelnetComposite.this.initControls();
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        Composite field = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        this.portLabel = new Label(field, 0);
        this.portLabel.setText("Port:");
        this.port = new Text(field, 2052);
        gd = new GridData(768);
        this.port.setLayoutData((Object)gd);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.portLabel);
        this.controls.add(this.port);
        this.loadCommandLabel = new Label(field, 0);
        this.loadCommandLabel.setText("Load command:");
        this.loadCommand = new Text(field, 2052);
        gd = new GridData(768);
        this.loadCommand.setLayoutData((Object)gd);
        this.loadCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.loadCommandLabel);
        this.controls.add(this.loadCommand);
        this.verbose = new Button(field, 32);
        this.verbose.setText("Verbose mode");
        gd = new GridData(768);
        this.verbose.setLayoutData((Object)gd);
        this.verbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.verbose);
        this.deleteOnExit = new Button(row, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.deleteOnExit.setLayoutData((Object)gd);
        this.deleteOnExit.setText("Delete file on target after program termination");
        this.deleteOnExit.setToolTipText("Delete file on target after program termination");
        this.deleteOnExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.deleteOnExit);
        this.interactive = new Button(row, 32);
        this.interactive.setText("Interactive Telnet session");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.interactive.setLayoutData((Object)gd);
        this.interactive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TelnetComposite.this.interactive.getSelection()) {
                    TelnetComposite.this.loadCommandLabel.setEnabled(false);
                    TelnetComposite.this.loadCommand.setEnabled(false);
                    TelnetComposite.this.verbose.setEnabled(false);
                    TelnetComposite.this.deleteOnExit.setEnabled(false);
                    TelnetComposite.this.autoLogin.setEnabled(true);
                } else {
                    TelnetComposite.this.loadCommandLabel.setEnabled(true);
                    TelnetComposite.this.loadCommand.setEnabled(true);
                    TelnetComposite.this.verbose.setEnabled(true);
                    TelnetComposite.this.deleteOnExit.setEnabled(true);
                    TelnetComposite.this.autoLogin.setEnabled(false);
                }
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.interactive);
        Composite indent = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = false;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 3;
        indent.setLayout((Layout)gl);
        new Label(indent, 0);
        new Label(indent, 0);
        this.autoLogin = new Button(indent, 32);
        this.autoLogin.setText("Auto login");
        gd = new GridData(768);
        this.autoLogin.setLayoutData((Object)gd);
        this.autoLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TelnetComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.autoLogin);
        return comp;
    }

    protected void updateLaunchConfigurationDialog() {
        this.targetRemoteExecutionTab.updateLaunchConfigurationDialog();
    }

    public String getTypeTitle() {
        return "Telnet";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ATTR_PORT, "23");
        config.setAttribute(ATTR_LOAD_COMMAND, "." + File.separator + "%b" + " " + "%a");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.typeSelection.getSelection()) {
            config.setAttribute("remoteExecutionType", "Telnet");
        }
        config.setAttribute(ATTR_PORT, this.port.getText());
        config.setAttribute(ATTR_LOAD_COMMAND, this.loadCommand.getText());
        config.setAttribute(ATTR_DELETE_ON_EXIT, this.deleteOnExit.getSelection());
        config.setAttribute("remoteExecutionVerbose", this.verbose.getSelection());
        config.setAttribute(ATTR_INTERACTIVE, this.interactive.getSelection());
        config.setAttribute(ATTR_INTERACTIVE_AUTOLOGIN, this.autoLogin.getSelection());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (config.getAttribute("remoteExecutionType", "none").equals("Telnet")) {
                this.typeSelection.setSelection(true);
            } else {
                this.typeSelection.setSelection(false);
            }
            this.port.setText(config.getAttribute(ATTR_PORT, "23"));
            this.loadCommand.setText(config.getAttribute(ATTR_LOAD_COMMAND, ""));
            this.deleteOnExit.setSelection(config.getAttribute(ATTR_DELETE_ON_EXIT, false));
            this.verbose.setSelection(config.getAttribute("remoteExecutionVerbose", false));
            this.interactive.setSelection(config.getAttribute(ATTR_INTERACTIVE, false));
            this.autoLogin.setSelection(config.getAttribute(ATTR_INTERACTIVE_AUTOLOGIN, false));
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from telnet launch config");
            e.printStackTrace();
        }
    }

    protected void validate() {
        if (this.typeSelection.getSelection() && !this.interactive.getSelection() && this.loadCommand.getText().length() < 1) {
            this.targetRemoteExecutionTab.setErrorMessage("No load command spcified.");
        }
    }

    protected void setControlsEnabled(boolean b) {
        this.setControlsEnabled(b, false);
    }

    protected void setControlsEnabled(boolean b, boolean includeTitle) {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(b);
        }
        if (includeTitle) {
            this.typeSelection.setEnabled(b);
        }
    }

    protected void initControls() {
        if (this.typeSelection.getSelection()) {
            this.targetRemoteExecutionTab.setGeneralControlsEnabled(true);
            this.setControlsEnabled(true, true);
            if (this.interactive.getSelection()) {
                this.loadCommandLabel.setEnabled(false);
                this.loadCommand.setEnabled(false);
                this.verbose.setEnabled(false);
                this.deleteOnExit.setEnabled(false);
                this.autoLogin.setEnabled(true);
            } else {
                this.loadCommandLabel.setEnabled(true);
                this.loadCommand.setEnabled(true);
                this.verbose.setEnabled(true);
                this.deleteOnExit.setEnabled(true);
                this.autoLogin.setEnabled(false);
            }
        } else {
            this.setControlsEnabled(false, false);
            this.typeSelection.setEnabled(true);
        }
    }
}

