/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaConfSettings;
import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class TargetsPage {
    private VisualTarget[] targetTabs = new VisualTarget[TargetsPage.getTargetList().size() + 1];

    public TargetsPage(JamaicaConfSettings defaults) {
        VisualTarget visualTarget = new VisualTarget(defaults, VisualTarget.GLOBAL, "global");
        int i = 0;
        this.targetTabs[i] = visualTarget;
        Iterator it = TargetsPage.getTargetList().iterator();
        while (it.hasNext()) {
            this.targetTabs[++i] = visualTarget = new VisualTarget(defaults, VisualTarget.TARGET, (String)it.next());
        }
    }

    public static ArrayList getTargetList() {
        Properties jamaicaConf = new Properties();
        ArrayList<String> targets = new ArrayList<String>();
        String filename = "";
        String jamaicaHome = JamaicaPlugin.getDefault().getPreferenceStore().getString("JamaicaHome");
        filename = !jamaicaHome.endsWith(File.separator) ? String.valueOf(jamaicaHome) + File.separator + "etc" + File.separator + "jamaica.conf" : String.valueOf(jamaicaHome) + "etc" + File.separator + "jamaica.conf";
        FileInputStream cfgstream = null;
        String userConf = String.valueOf(System.getProperty("user.home")) + File.separator + ".jamaica" + File.separator + "jamaica.conf";
        if (new File(userConf).exists()) {
            filename = userConf;
        }
        try {
            cfgstream = new FileInputStream(filename);
            jamaicaConf.load(cfgstream);
            cfgstream.close();
            Enumeration<?> keys = jamaicaConf.propertyNames();
            while (keys.hasMoreElements()) {
                String targetName;
                String key = (String)keys.nextElement();
                int pos = key.indexOf(46);
                if (pos == -1 || targets.contains(targetName = key.substring(pos + 1))) continue;
                targets.add(targetName);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Jamacia Plugin: Error reading jamaica.conf: " + filename);
            MessageDialog.openError((Shell)new Shell(), (String)"Jamaica Builder", (String)JamaicaPlugin.getResourceString("ErrorMessage_ReadingConfigFile"));
            targets = null;
        }
        catch (IOException iOException) {
            System.err.println("Jamacia Plugin: IOError reading jamaica.conf: " + filename);
        }
        int hostIndex = targets.indexOf("host");
        if (hostIndex > 0) {
            targets.add(0, (String)targets.remove(hostIndex));
        }
        return targets;
    }

    public static String[] getTargetNames() {
        Iterator it = TargetsPage.getTargetList().iterator();
        String[] targetNames = new String[TargetsPage.getTargetList().size()];
        int i = 0;
        while (it.hasNext()) {
            targetNames[i] = (String)it.next();
            ++i;
        }
        return targetNames;
    }

    public VisualTarget[] getTargetTabs() {
        return this.targetTabs;
    }
}

