/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.ExpectComposite;
import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import com.aicas.jamaica.eclipse.ui.ScriptRemoteExecutionComposite;
import com.aicas.jamaica.eclipse.ui.TelnetComposite;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetRemoteExecutionTab
extends AbstractLaunchConfigurationTab {
    private static RemoteExecutionType[] remoteExecutionTypes;
    private ArrayList generalControls = new ArrayList();
    private Label generalLabel;
    private Text host;
    private Label hostLabel;
    private Text username;
    private Label usernameLabel;
    private Text password;
    private Label passwordLabel;
    private Text arguments;
    private Label argumentsLabel;
    private Button skipExecution;
    private Label noteTitle;
    private Label note;

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.setControl((Control)sc);
        remoteExecutionTypes = new RemoteExecutionType[]{new TelnetComposite(this), new ExpectComposite(this), new ScriptRemoteExecutionComposite(this)};
        this.createSkipComposite(composite);
        this.createGeneralComposite(composite);
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            if (i != 0) {
                this.createSpaceComponent(composite);
            }
            remoteExecutionTypes[i].createControl(composite);
            ++i;
        }
        Point minSize = composite.computeSize(-1, -1);
        sc.setExpandVertical(true);
        sc.setMinWidth(minSize.x);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(minSize.y);
    }

    private void createSkipComposite(Composite comp) {
        this.skipExecution = new Button(comp, 16);
        this.skipExecution.setText("Skip remote execution");
        try {
            FontData fd = this.skipExecution.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.skipExecution.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.skipExecution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TargetRemoteExecutionTab.this.setAllControlsEnabled(false, false);
                TargetRemoteExecutionTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createVariablesInfoComposite(Composite comp) {
        Composite field = new Composite(comp, 0);
        GridData gd = new GridData(834);
        gd.verticalSpan = 4;
        field.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 20;
        gl.numColumns = 1;
        field.setLayout((Layout)gl);
        this.noteTitle = new Label(field, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.noteTitle.setLayoutData((Object)gd);
        this.noteTitle.setText("The arguments and command fields accept the \nfollowing variables:");
        this.generalControls.add(this.noteTitle);
        this.note = new Label(field, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.note.setLayoutData((Object)gd);
        try {
            this.note.setFont(new Font((Device)this.note.getDisplay(), "Courier", 10, 0));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.note.setText(" %h   Host\n %u   Username\n %p   Password\n %a   Arguments\n %f   Absolute path of application (on host)\n %d   Remote directory\n %b   Name of application (on target)\n");
        this.generalControls.add(this.note);
    }

    private void createSpaceComponent(Composite comp) {
        new Label(comp, 0);
    }

    private void createGeneralComposite(Composite comp) {
        this.generalLabel = new Label(comp, 0);
        this.generalLabel.setText("General settings");
        try {
            FontData fd = this.generalLabel.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.generalLabel.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.generalControls.add(this.generalLabel);
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        Composite field = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        this.hostLabel = new Label(field, 0);
        this.hostLabel.setText("Host:");
        this.host = new Text(field, 2052);
        gd = new GridData(768);
        this.host.setLayoutData((Object)gd);
        this.host.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetRemoteExecutionTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.hostLabel);
        this.generalControls.add(this.host);
        this.createVariablesInfoComposite(row);
        this.usernameLabel = new Label(field, 0);
        this.usernameLabel.setText("Username:");
        this.username = new Text(field, 2052);
        gd = new GridData(768);
        this.username.setLayoutData((Object)gd);
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetRemoteExecutionTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.usernameLabel);
        this.generalControls.add(this.username);
        this.passwordLabel = new Label(field, 0);
        this.passwordLabel.setText("Password:");
        this.password = new Text(field, 2052);
        this.password.setEchoChar('*');
        gd = new GridData(768);
        this.password.setLayoutData((Object)gd);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetRemoteExecutionTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.passwordLabel);
        this.generalControls.add(this.password);
        this.argumentsLabel = new Label(field, 0);
        this.argumentsLabel.setText("Arguments:");
        this.arguments = new Text(field, 2052);
        gd = new GridData(768);
        this.arguments.setLayoutData((Object)gd);
        this.arguments.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetRemoteExecutionTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.argumentsLabel);
        this.generalControls.add(this.arguments);
    }

    public static RemoteExecutionType[] getTypes() {
        return remoteExecutionTypes;
    }

    public void setAllControlsEnabled(boolean b) {
        this.setAllControlsEnabled(b, true);
    }

    public void setAllControlsEnabled(boolean b, boolean includeTitles) {
        this.setGeneralControlsEnabled(b);
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            remoteExecutionTypes[i].setControlsEnabled(b, includeTitles);
            ++i;
        }
    }

    public void setGeneralControlsEnabled(boolean bool) {
        Iterator iter = this.generalControls.iterator();
        this.host.setEditable(bool);
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(bool);
        }
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfig) {
        TargetSiteAccess.setCurrentConfig(launchConfig);
        launchConfig.setAttribute("remoteExecutionType", "none");
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            remoteExecutionTypes[i].setDefaults(launchConfig);
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        try {
            TargetSiteAccess.setCurrentConfig(launchConfig.getWorkingCopy());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        String downloadHost = "";
        String downloadUsername = "";
        String target = "host";
        try {
            downloadHost = launchConfig.getAttribute("downloadHost", "");
            downloadUsername = launchConfig.getAttribute("downloadUsername", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            if (launchConfig.getAttribute("remoteExecutionType", "none").equals("none")) {
                this.skipExecution.setSelection(true);
            } else {
                this.skipExecution.setSelection(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            String val = launchConfig.getAttribute("remoteExecutionHost", "");
            if (downloadHost.length() > 0 && val.length() < 1) {
                this.host.setText(downloadHost);
            } else {
                this.host.setText(val);
            }
            val = launchConfig.getAttribute("remoteExecutionUername", "");
            if (!downloadUsername.equals("") && val.equals("")) {
                this.username.setText(downloadUsername);
            } else {
                this.username.setText(val);
            }
            this.password.setText(launchConfig.getAttribute("remoteExecutionPassword", ""));
            this.arguments.setText(launchConfig.getAttribute("remoteExecutionArguments", ""));
            target = launchConfig.getAttribute("target", "");
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from telnet launch config");
            e.printStackTrace();
        }
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            remoteExecutionTypes[i].initializeFrom(launchConfig);
            ++i;
        }
        this.setAllControlsEnabled(false);
        this.skipExecution.setEnabled(false);
        if (!target.equals("host")) {
            this.skipExecution.setEnabled(true);
            i = 0;
            while (i < remoteExecutionTypes.length) {
                remoteExecutionTypes[i].initControls();
                ++i;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        TargetSiteAccess.setCurrentConfig(launchConfig);
        if (this.skipExecution.getSelection()) {
            launchConfig.setAttribute("remoteExecutionType", "none");
        }
        launchConfig.setAttribute("remoteExecutionHost", this.host.getText());
        launchConfig.setAttribute("remoteExecutionUername", this.username.getText());
        launchConfig.setAttribute("remoteExecutionPassword", this.password.getText());
        launchConfig.setAttribute("remoteExecutionArguments", this.arguments.getText());
        launchConfig.setAttribute("configID", launchConfig.getName());
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            remoteExecutionTypes[i].performApply(launchConfig);
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        int i = 0;
        while (i < remoteExecutionTypes.length) {
            remoteExecutionTypes[i].validate();
            ++i;
        }
        if (this.skipExecution.getSelection()) {
            this.setErrorMessage(null);
        }
        return this.getErrorMessage() == null;
    }

    protected void setErrorMessage(String msg) {
        super.setErrorMessage(msg);
    }

    public String getName() {
        return "Remote Execution";
    }
}

