/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.ui.TargetsPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetMainTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_REMOTE_DIRECTORY = "remoteDirectory";
    public static final String ATTR_PROGRAM_NAME = "programName";
    public static final String ATTR_CONFIG_ID = "configID";
    public static final String ATTR_USE_GLOBAL_PROGRAM_NAME = "useGlobalProgramName";
    public static final String ATTR_PATH_BUILT_APPLICATION = "pathBuiltApplication";
    private final String LOCALHOST = "Execute application on localhost";
    private Combo targetCombo;
    private Label remoteDirectoryLabel;
    private Text remoteDirectory;
    private Button useGlobalProgramName;
    private Text programName;
    private boolean needsDownload = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        comp.setLayoutData((Object)new GridData(1808));
        ScrolledComposite sc = new ScrolledComposite(comp, 768);
        sc.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite row = new Composite(composite, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        this.createSelectionComp(row);
        new Label(row, 0);
        new Label(row, 0);
        new Label(row, 0);
        this.createUtilsComponent(row);
        Point minSize = composite.computeSize(-1, -1);
        sc.setExpandVertical(true);
        sc.setMinWidth(minSize.x);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(minSize.y);
    }

    private void createSelectionComp(Composite comp) {
        Composite info = new Composite(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        info.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        info.setLayout((Layout)gl);
        new Label(info, 0).setText("If supported by the target, FTP and Telnet can be\nused to download and start your application remotely.\nOtherwise provide your own script that performs these tasks.");
        new Label(comp, 0);
        new Label(comp, 0);
        Composite row = new Composite(comp, 0);
        gd = new GridData(768);
        row.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        new Label(row, 0).setText("Target:");
        this.targetCombo = new Combo(row, 76);
        gd = new GridData(768);
        this.targetCombo.setLayoutData((Object)gd);
        this.fillComboBox(this.targetCombo, TargetsPage.getTargetNames());
        int i = 0;
        while (i < this.targetCombo.getItems().length) {
            if (this.targetCombo.getItem(i).equals("host")) {
                this.targetCombo.setItem(i, "Execute application on localhost");
            }
            ++i;
        }
        this.targetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (TargetMainTab.this.targetCombo.getSelectionIndex() == TargetMainTab.this.targetCombo.getItemCount() - 1) {
                    TargetMainTab.this.enableTargetLocalhostControls(true);
                } else {
                    TargetMainTab.this.enableTargetLocalhostControls(false);
                }
                TargetMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createUtilsComponent(Composite comp) {
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        this.remoteDirectoryLabel = new Label(row, 0);
        this.remoteDirectoryLabel.setText("Remote Directory");
        this.remoteDirectoryLabel.setToolTipText("Specifies the absolute path of the directory on the target where the application will be downloaded to");
        this.remoteDirectory = new Text(row, 2052);
        gd = new GridData(768);
        this.remoteDirectory.setLayoutData((Object)gd);
        this.remoteDirectory.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                TargetMainTab.this.needsDownload = true;
                TargetMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.useGlobalProgramName = new Button(row, 32);
        this.useGlobalProgramName.setText("Always use this program name");
        this.useGlobalProgramName.setToolTipText("Use always the same file name for any\napplication downloaded to this target.\nOtherwise, the name generated by the Builder will be used.");
        this.useGlobalProgramName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TargetMainTab.this.programName.setEnabled(TargetMainTab.this.useGlobalProgramName.getSelection());
                TargetMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.programName = new Text(row, 2052);
        gd = new GridData(768);
        this.programName.setLayoutData((Object)gd);
        this.programName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(row, 0);
    }

    private void enableTargetLocalhostControls(boolean b) {
        this.remoteDirectoryLabel.setEnabled(b);
        this.remoteDirectory.setEnabled(b);
        this.useGlobalProgramName.setEnabled(b);
        this.programName.setEnabled(b);
    }

    private void fillComboBox(Combo combo, String[] types) {
        int i = 0;
        while (i < types.length) {
            combo.add(types[i]);
            ++i;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ATTR_USE_GLOBAL_PROGRAM_NAME, true);
        config.setAttribute(ATTR_PROGRAM_NAME, "a.out");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            JavaProjectTypes.setCurrentConfig(config.getWorkingCopy());
            if (config.getAttribute(ATTR_TARGET, "").equals("host")) {
                this.targetCombo.setText("Execute application on localhost");
            } else {
                this.targetCombo.setText(config.getAttribute(ATTR_TARGET, ""));
            }
            this.remoteDirectory.setText(config.getAttribute(ATTR_REMOTE_DIRECTORY, ""));
            this.useGlobalProgramName.setSelection(config.getAttribute(ATTR_USE_GLOBAL_PROGRAM_NAME, true));
            this.programName.setText(config.getAttribute(ATTR_PROGRAM_NAME, "a.out"));
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error loading values from target site config");
        }
        if (this.targetCombo.getText().equals("Execute application on localhost")) {
            this.enableTargetLocalhostControls(false);
        } else {
            this.enableTargetLocalhostControls(true);
            if (!this.useGlobalProgramName.getSelection()) {
                this.programName.setEnabled(false);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.targetCombo.getText().equals("Execute application on localhost")) {
            config.setAttribute(ATTR_TARGET, "host");
        } else {
            config.setAttribute(ATTR_TARGET, this.targetCombo.getText());
        }
        config.setAttribute(ATTR_REMOTE_DIRECTORY, this.remoteDirectory.getText());
        config.setAttribute(ATTR_USE_GLOBAL_PROGRAM_NAME, this.useGlobalProgramName.getSelection());
        config.setAttribute(ATTR_PROGRAM_NAME, this.programName.getText());
        if (this.needsDownload) {
            config.setAttribute("needsDownload", true);
        }
    }

    public String getName() {
        return "Main";
    }
}

