/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.ui.DownloadType;
import com.aicas.jamaica.eclipse.ui.FTPComposite;
import com.aicas.jamaica.eclipse.ui.ScriptDownloadComposite;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetDownloadTab
extends AbstractLaunchConfigurationTab {
    private static DownloadType[] downloadTypes;
    private ArrayList generalControls = new ArrayList();
    private Label generalLabel;
    private Text host;
    private Label hostLabel;
    private Text password;
    private Label passwordLabel;
    private Text username;
    private Label usernameLabel;
    private Button smartDownload;
    private Button skipDownload;

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.setControl((Control)sc);
        downloadTypes = new DownloadType[]{new FTPComposite(this), new ScriptDownloadComposite(this)};
        this.createSkipComposite(composite);
        this.createGeneralComposite(composite);
        int i = 0;
        while (i < downloadTypes.length) {
            this.createSpaceComponent(composite);
            downloadTypes[i].createControl(composite);
            ++i;
        }
        Point minSize = composite.computeSize(-1, -1);
        sc.setExpandVertical(true);
        sc.setMinWidth(minSize.x);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(minSize.y);
    }

    private void createSpaceComponent(Composite comp) {
        new Label(comp, 0);
    }

    private void createSkipComposite(Composite comp) {
        this.skipDownload = new Button(comp, 16);
        this.skipDownload.setText("Skip download task");
        try {
            FontData fd = this.skipDownload.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.skipDownload.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.skipDownload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TargetDownloadTab.this.setAllControlsEnabled(false, false);
                TargetDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGeneralComposite(Composite comp) {
        this.generalLabel = new Label(comp, 0);
        this.generalLabel.setText("General settings");
        try {
            FontData fd = this.generalLabel.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.generalLabel.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.generalControls.add(this.generalLabel);
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        Composite field = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        this.hostLabel = new Label(field, 0);
        this.hostLabel.setText("Host:");
        this.host = new Text(field, 2052);
        gd = new GridData(768);
        this.host.setLayoutData((Object)gd);
        this.host.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.hostLabel);
        this.generalControls.add(this.host);
        this.usernameLabel = new Label(field, 0);
        this.usernameLabel.setText("Username:");
        this.username = new Text(field, 2052);
        gd = new GridData(768);
        this.username.setLayoutData((Object)gd);
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.usernameLabel);
        this.generalControls.add(this.username);
        this.passwordLabel = new Label(field, 0);
        this.passwordLabel.setText("Password:");
        this.password = new Text(field, 2052);
        this.password.setEchoChar('*');
        gd = new GridData(768);
        this.password.setLayoutData((Object)gd);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TargetDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.passwordLabel);
        this.generalControls.add(this.password);
        this.smartDownload = new Button(field, 32);
        this.smartDownload.setText("Smart download");
        this.smartDownload.setToolTipText("Only download application if it was rebuilt before.");
        this.smartDownload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TargetDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generalControls.add(this.smartDownload);
    }

    public static DownloadType[] getTypes() {
        return downloadTypes;
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("downloadType", "none");
        int i = 0;
        while (i < downloadTypes.length) {
            downloadTypes[i].setDefaults(launchConfig);
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        String target = "host";
        try {
            if (launchConfig.getAttribute("downloadType", "none").equals("none")) {
                this.skipDownload.setSelection(true);
            } else {
                this.skipDownload.setSelection(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String remoteExecutionHost = "";
        String remoteExecutionUsername = "";
        try {
            remoteExecutionHost = launchConfig.getAttribute("remoteExecutionHost", "");
            remoteExecutionUsername = launchConfig.getAttribute("remoteExecutionUername", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            String val = launchConfig.getAttribute("downloadHost", "");
            if (remoteExecutionHost.length() > 0 && !remoteExecutionHost.equals("localhost") && val.length() < 1) {
                this.host.setText(remoteExecutionHost);
            } else {
                this.host.setText(val);
            }
            val = launchConfig.getAttribute("downloadUsername", "");
            if (remoteExecutionUsername.length() > 0 && val.length() < 1) {
                this.username.setText(remoteExecutionUsername);
            } else {
                this.username.setText(val);
            }
            this.password.setText(launchConfig.getAttribute("downloadPassword", ""));
            this.smartDownload.setSelection(launchConfig.getAttribute("downloadSmart", true));
            target = launchConfig.getAttribute("target", "");
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from ftp launch config");
            e.printStackTrace();
        }
        int i = 0;
        while (i < downloadTypes.length) {
            downloadTypes[i].initializeFrom(launchConfig);
            ++i;
        }
        this.setAllControlsEnabled(false);
        this.skipDownload.setEnabled(false);
        if (!target.equals("host")) {
            this.skipDownload.setEnabled(true);
            i = 0;
            while (i < downloadTypes.length) {
                downloadTypes[i].initControls();
                ++i;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.skipDownload.getSelection()) {
            launchConfig.setAttribute("downloadType", "none");
        }
        launchConfig.setAttribute("downloadHost", this.host.getText());
        launchConfig.setAttribute("downloadUsername", this.username.getText());
        launchConfig.setAttribute("downloadPassword", this.password.getText());
        launchConfig.setAttribute("downloadSmart", this.smartDownload.getSelection());
        launchConfig.setAttribute("configID", launchConfig.getName());
        int i = 0;
        while (i < downloadTypes.length) {
            downloadTypes[i].performApply(launchConfig);
            ++i;
        }
    }

    public void setAllControlsEnabled(boolean b) {
        this.setAllControlsEnabled(b, true);
    }

    public void setAllControlsEnabled(boolean b, boolean includeTitles) {
        this.setGeneralControlsEnabled(b);
        int i = 0;
        while (i < downloadTypes.length) {
            downloadTypes[i].setControlsEnabled(b, includeTitles);
            ++i;
        }
    }

    public void setGeneralControlsEnabled(boolean bool) {
        Iterator iter = this.generalControls.iterator();
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(bool);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        int i = 0;
        while (i < downloadTypes.length) {
            downloadTypes[i].validate();
            ++i;
        }
        return this.getErrorMessage() == null;
    }

    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public String getName() {
        return "Download";
    }
}

