/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.target.ScriptDownload;
import com.aicas.jamaica.eclipse.target.ScriptRemoteExecution;
import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import com.aicas.jamaica.eclipse.ui.TargetRemoteExecutionTab;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScriptRemoteExecutionComposite
extends RemoteExecutionType {
    private ArrayList controls = new ArrayList();
    private TargetRemoteExecutionTab targetRemoteExecutionTab;
    private Button typeSelection;
    private Label fileLabel;
    private Text scriptText;
    private Button scriptBrowse;
    public static final String ATTR_COMMAND = "scriptRemoteExecutionCommand";

    public ScriptRemoteExecutionComposite(TargetRemoteExecutionTab parentTab) {
        this.targetRemoteExecutionTab = parentTab;
    }

    public Composite createControl(Composite comp) {
        this.typeSelection = new Button(comp, 16);
        this.typeSelection.setText("User defined remote execution");
        try {
            FontData fd = this.typeSelection.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.typeSelection.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.typeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScriptRemoteExecutionComposite.this.initControls();
                ScriptRemoteExecutionComposite.this.updateLaunchConfigurationDialog();
            }
        });
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        Composite field = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 3;
        field.setLayout((Layout)gl);
        this.fileLabel = new Label(field, 16384);
        this.fileLabel.setText("Command:");
        this.controls.add(this.fileLabel);
        this.scriptText = new Text(field, 2052);
        gd = new GridData(768);
        this.scriptText.setLayoutData((Object)gd);
        this.scriptText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ScriptRemoteExecutionComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.scriptText);
        this.scriptBrowse = new Button(field, 8);
        this.scriptBrowse.setText("Browse...");
        this.scriptBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String file = ScriptRemoteExecutionComposite.this.openFileDialog();
                if (file != null) {
                    ScriptRemoteExecutionComposite.this.scriptText.setText(file);
                }
            }
        });
        this.controls.add(this.scriptBrowse);
        return comp;
    }

    private String openFileDialog() {
        FileDialog dialog = new FileDialog(new Shell(2144), 4096);
        dialog.setText("File Browser");
        dialog.setFilterPath(Platform.getLocation().toString());
        return dialog.open();
    }

    public String getTypeTitle() {
        return ScriptDownload.ID;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.typeSelection.getSelection()) {
            config.setAttribute("remoteExecutionType", ScriptRemoteExecution.ID);
        }
        config.setAttribute(ATTR_COMMAND, this.scriptText.getText());
        config.setAttribute("configID", config.getName());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (config.getAttribute("remoteExecutionType", "none").equals(ScriptRemoteExecution.ID)) {
                this.typeSelection.setSelection(true);
            } else {
                this.typeSelection.setSelection(false);
            }
            this.scriptText.setText(config.getAttribute(ATTR_COMMAND, ""));
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from download script launch config");
            e.printStackTrace();
        }
    }

    protected void updateLaunchConfigurationDialog() {
        this.targetRemoteExecutionTab.updateLaunchConfigurationDialog();
    }

    protected void validate() {
    }

    protected void setControlsEnabled(boolean b) {
        this.setControlsEnabled(b, false);
    }

    protected void setControlsEnabled(boolean b, boolean includeTitle) {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(b);
        }
        if (includeTitle) {
            this.typeSelection.setEnabled(b);
        }
    }

    protected void initControls() {
        if (this.typeSelection.getSelection()) {
            this.targetRemoteExecutionTab.setGeneralControlsEnabled(true);
            this.setControlsEnabled(true, true);
        } else {
            this.setControlsEnabled(false, false);
            this.typeSelection.setEnabled(true);
        }
    }
}

