/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.target.ScriptRemoteExecution;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.TelnetComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;

public abstract class RemoteExecutionType {
    public static final String ATTR_TYPE = "remoteExecutionType";
    public static final String ATTR_HOST = "remoteExecutionHost";
    public static final String ATTR_USERNAME = "remoteExecutionUername";
    public static final String ATTR_PASSWORD = "remoteExecutionPassword";
    public static final String ATTR_ARGUMENTS = "remoteExecutionArguments";
    public static final String VARIABLES_INFO = " %h   Host\n %u   Username\n %p   Password\n %a   Arguments\n %f   Absolute path of application (on host)\n %d   Remote directory\n %b   Name of application (on target)\n";
    public static final String NILARG = "<nil>";

    public abstract Composite createControl(Composite var1);

    public abstract String getTypeTitle();

    public abstract void performApply(ILaunchConfigurationWorkingCopy var1);

    public abstract void setDefaults(ILaunchConfigurationWorkingCopy var1);

    public abstract void initializeFrom(ILaunchConfiguration var1);

    protected abstract void updateLaunchConfigurationDialog();

    protected abstract void setControlsEnabled(boolean var1);

    protected abstract void setControlsEnabled(boolean var1, boolean var2);

    protected abstract void initControls();

    protected abstract void validate();

    public static String generateArguments(ILaunchConfiguration config) {
        String host = NILARG;
        String port = "23";
        String username = NILARG;
        String password = NILARG;
        String arguments = NILARG;
        String remoteDirectory = NILARG;
        String programName = NILARG;
        String loadCommand = NILARG;
        String pathBuiltApplication = "";
        String commandScript = "";
        boolean deleteOnExit = false;
        boolean isVerbose = false;
        String type = "";
        try {
            host = config.getAttribute(ATTR_HOST, NILARG);
            port = config.getAttribute(TelnetComposite.ATTR_PORT, "23");
            username = config.getAttribute(ATTR_USERNAME, NILARG);
            password = config.getAttribute(ATTR_PASSWORD, NILARG);
            arguments = config.getAttribute(ATTR_ARGUMENTS, "");
            remoteDirectory = config.getAttribute("remoteDirectory", ".");
            programName = config.getAttribute("programName", NILARG);
            loadCommand = config.getAttribute(TelnetComposite.ATTR_LOAD_COMMAND, NILARG);
            pathBuiltApplication = config.getAttribute("pathBuiltApplication", "");
            commandScript = config.getAttribute("scriptRemoteExecutionCommand", null);
            deleteOnExit = config.getAttribute(TelnetComposite.ATTR_DELETE_ON_EXIT, false);
            isVerbose = config.getAttribute("remoteExecutionVerbose", false);
            type = config.getAttribute(ATTR_TYPE, "");
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (host.length() < 1) {
            host = NILARG;
        }
        if (port.length() < 1) {
            port = "23";
        }
        if (username.length() < 1) {
            username = NILARG;
        }
        if (password.length() < 1) {
            password = NILARG;
        }
        if (remoteDirectory.length() < 1) {
            remoteDirectory = NILARG;
        }
        if (programName.length() < 1) {
            programName = NILARG;
        }
        if (loadCommand.length() < 1) {
            loadCommand = NILARG;
        }
        if (pathBuiltApplication.length() < 1) {
            pathBuiltApplication = NILARG;
        }
        String result = "";
        if (type.equals("Telnet")) {
            result = String.valueOf(host) + " " + port + " " + username + " " + password + " " + remoteDirectory + " " + programName + " " + isVerbose + " " + deleteOnExit + " " + loadCommand;
        } else if (type.equals(ScriptRemoteExecution.ID) && commandScript.indexOf(32) > 0) {
            result = commandScript.substring(commandScript.indexOf(32));
        }
        result = TargetSiteAccess.replaceSubstring(result, "%h", host);
        result = TargetSiteAccess.replaceSubstring(result, "%u", username);
        result = TargetSiteAccess.replaceSubstring(result, "%p", password);
        result = TargetSiteAccess.replaceSubstring(result, "%a", arguments);
        result = TargetSiteAccess.replaceSubstring(result, "%f", pathBuiltApplication);
        result = TargetSiteAccess.replaceSubstring(result, "%d", remoteDirectory);
        result = TargetSiteAccess.replaceSubstring(result, "%b", programName);
        return result;
    }
}

