/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.range.StringRange;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class OptionEditDialog
extends Dialog {
    private VisualOption visualOption;
    private boolean isClasspath = false;
    private ListField listField = null;
    private Composite composite;

    public OptionEditDialog(Shell parentShell, VisualOption visualOption) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.visualOption = visualOption;
        if (visualOption.getOption().getName().equals("classpath") || visualOption.getOption().getName().equals("Xbootclasspath")) {
            this.isClasspath = true;
        }
    }

    public int open() {
        StringRange range = (StringRange)this.visualOption.getOption().getRange();
        if (range.isListOption()) {
            return super.open();
        }
        String returnValue = this.openNewEntryDialog();
        if (returnValue != null) {
            this.visualOption.setValue(returnValue);
        }
        return 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite;
        this.composite = composite = (Composite)super.createDialogArea(parent);
        this.listField = new ListField("", "\nOption '" + this.visualOption.getOption().getName() + "'", composite);
        this.listField.createContent();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Editing Jamaica Builder options");
    }

    protected void okPressed() {
        String newValue = "";
        int i = 0;
        while (i < this.listField.getList().getItemCount()) {
            newValue = String.valueOf(newValue) + (i > 0 ? (this.isClasspath ? "" + File.pathSeparator : " ") : "") + this.listField.getList().getItem(i);
            ++i;
        }
        this.visualOption.setValue(newValue);
        this.close();
    }

    private String openNewEntryDialog() {
        String entry;
        StringRange range = (StringRange)this.visualOption.getOption().getRange();
        int dialogID = range.getDialogID();
        switch (dialogID) {
            case 1: {
                entry = this.openFileDialog();
                break;
            }
            case 2: {
                entry = this.openDirectoryDialog();
                break;
            }
            case 3: {
                entry = this.openClassBrowser();
                break;
            }
            default: {
                entry = this.openInputDialog();
            }
        }
        return entry;
    }

    private String openClassBrowser() {
        IJavaElement[] elements = new IJavaElement[]{this.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
        TypeSelectionDialog dialog = new TypeSelectionDialog(new Shell(2144), (IRunnableContext)context, 5, scope);
        dialog.setTitle("Class Browser");
        dialog.setMessage("Enter a class name");
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            if (type != null) {
                return JavaModelUtil.getFullyQualifiedName((IType)type);
            }
            return null;
        }
        return null;
    }

    private String openFileDialog() {
        FileDialog dialog = new FileDialog(new Shell(2144), 4096);
        dialog.setText("File Browser");
        dialog.setFilterPath(Platform.getLocation().toString());
        return dialog.open();
    }

    private String openDirectoryDialog() {
        DirectoryDialog dialog = new DirectoryDialog(new Shell(2144), 0);
        dialog.setText("Directory Browser");
        dialog.setFilterPath(Platform.getLocation().toString());
        return dialog.open();
    }

    private String openInputDialog() {
        boolean answer;
        Shell shell = new Shell(new Shell(2144));
        shell.setText("Input Dialog");
        InputDialog dialog = new InputDialog(shell, "Adding a new entry", "Add a new entry for option '" + this.visualOption.getOption().getName() + "':", "", null);
        boolean bl = answer = dialog.open() == 0;
        if (answer) {
            return dialog.getValue();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = "";
        try {
            projectName = JavaProjectTypes.getCurrentConfig().getAttribute("@projectName", null);
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error getting attribute @projectName");
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static /* synthetic */ String access$1(OptionEditDialog optionEditDialog) {
        return optionEditDialog.openFileDialog();
    }

    private class ListField
    extends ListEditor {
        private int entryCount;
        private List listControl;
        private Composite parent;
        private Button jarButton;
        private Button editButton;
        private PreferenceStore preferenceStore = new PreferenceStore();

        ListField(String name, String label, Composite parent) {
            super(name, String.valueOf('\n') + label, parent);
            this.parent = parent;
        }

        public void createContent() {
            Composite buttonControl;
            this.listControl = this.getListControl(this.parent);
            this.listControl.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ListField this$1;
                {
                    this.this$1 = listField;
                }

                public void widgetSelected(SelectionEvent evt) {
                    ListField.access$0(this.this$1).setEnabled(ListField.access$1(this.this$1).getSelectionIndex() >= 0);
                }
            });
            if (OptionEditDialog.this.isClasspath) {
                buttonControl = this.getButtonBoxControl(this.parent);
                this.jarButton = new Button(buttonControl, 0);
                this.jarButton.setLayoutData((Object)new GridData(768));
                this.jarButton.setText("Add JAR...");
                this.jarButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ ListField this$1;
                    {
                        this.this$1 = listField;
                    }

                    public void widgetSelected(SelectionEvent evt) {
                        String selectedJar = OptionEditDialog.access$1(ListField.access$3(this.this$1));
                        if (selectedJar != null) {
                            ListField.access$1(this.this$1).add(selectedJar);
                        }
                    }
                });
                this.jarButton.setEnabled(true);
            }
            buttonControl = this.getButtonBoxControl(this.parent);
            this.editButton = new Button(buttonControl, 0);
            this.editButton.setLayoutData((Object)new GridData(768));
            this.editButton.setText("Edit...");
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ListField this$1;
                {
                    this.this$1 = listField;
                }

                public void widgetSelected(SelectionEvent evt) {
                    boolean answer;
                    InputDialog dialog = new InputDialog(new Shell(), "Editing options", "Enter a value for option -" + OptionEditDialog.access$2(ListField.access$3(this.this$1)).getOption().getName(), ListField.access$1(this.this$1).getItem(ListField.access$1(this.this$1).getSelectionIndex()), null);
                    boolean bl = answer = dialog.open() == 0;
                    if (answer) {
                        ListField.access$1(this.this$1).setItem(ListField.access$1(this.this$1).getSelectionIndex(), dialog.getValue());
                    }
                }
            });
            this.editButton.setEnabled(false);
            this.setPreferenceStore((IPreferenceStore)this.preferenceStore);
            this.entryCount = 0;
            String value = OptionEditDialog.this.visualOption.getValue();
            value = value.replace(' ', File.pathSeparatorChar);
            StringTokenizer argumentTokens = new StringTokenizer(value, File.pathSeparator, false);
            while (argumentTokens.hasMoreTokens()) {
                try {
                    this.preferenceStore.putValue("entry_" + this.entryCount, argumentTokens.nextToken());
                    ++this.entryCount;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            this.load();
            this.listControl.select(this.getErrorItem());
        }

        private int getErrorItem() {
            int i = 0;
            boolean noError = true;
            while (i < this.listControl.getItemCount() && noError) {
                if (!new File(this.listControl.getItem(i)).exists()) {
                    noError = false;
                    this.listControl.select(i);
                    continue;
                }
                ++i;
            }
            return i;
        }

        protected String createList(String[] items) {
            return null;
        }

        protected String getNewInputObject() {
            return OptionEditDialog.this.openNewEntryDialog();
        }

        protected String[] parseString(String stringList) {
            String[] list = new String[this.entryCount];
            int i = 0;
            while (i < this.entryCount) {
                list[i] = this.preferenceStore.getString("entry_" + i);
                ++i;
            }
            return list;
        }

        private List getList() {
            return this.listControl;
        }

        static /* synthetic */ Button access$0(ListField listField) {
            return listField.editButton;
        }

        static /* synthetic */ List access$1(ListField listField) {
            return listField.listControl;
        }

        static /* synthetic */ OptionEditDialog access$3(ListField listField) {
            return listField.OptionEditDialog.this;
        }
    }
}

