/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.ui.TargetsPage;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class GeneralMainComposite {
    public static final String ATTR_MAINCLASSNAME = "@mainClassName";
    public static final String ATTR_PROGRAMNAME = "@programName";
    public static final String ATTR_PROJECTNAME = "@projectName";
    public static final String ATTR_PROJECTPATH = "@projectPath";
    public static final String ATTR_DIRECTEXECUTE = "@directExecute";
    private Combo fTargetSelectionCombo;
    private Label fTargetSelectionLabel;
    private Composite composite;
    private VisualTarget visualTarget;
    private VisualOption classpathText;
    private VisualOption destinationText;
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Label fMainLabel;
    private Text fMainText;
    private Button fSearchButton;
    private Button fDirectExecuteCheck;
    public static String projectName;

    public GeneralMainComposite(Composite composite, VisualTarget visualTarget) {
        this.composite = composite;
        this.visualTarget = visualTarget;
    }

    public void createControl() {
        Composite projComp = new Composite(this.composite, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText("Project:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setEditable(false);
        WorkbenchHelp.setHelp((Control)this.fProjText, (String)"com.aicas.jamaica.eclipse.project");
        this.fProjButton = SWTUtil.createPushButton((Composite)projComp, (String)"Browse...", null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralMainComposite.this.handleProjectButtonSelected();
            }
        });
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        Composite mainComp = new Composite(this.composite, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.fMainLabel = new Label(mainComp, 0);
        this.fMainLabel.setText("Main Class:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fMainLabel.setLayoutData((Object)gd);
        this.fMainText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fMainText.setEditable(false);
        this.fMainText.setLayoutData((Object)gd);
        WorkbenchHelp.setHelp((Control)this.fMainText, (String)"com.aicas.jamaica.eclipse.main");
        this.fSearchButton = SWTUtil.createPushButton((Composite)mainComp, (String)"Search...", null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GeneralMainComposite.this.handleSearchButtonSelected();
            }
        });
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        Composite targetSelectionComp = new Composite(this.composite, 0);
        GridLayout targetLayout = new GridLayout();
        targetLayout.numColumns = 2;
        targetLayout.marginHeight = 0;
        targetLayout.marginWidth = 0;
        targetSelectionComp.setLayout((Layout)targetLayout);
        gd = new GridData(768);
        targetSelectionComp.setLayoutData((Object)gd);
        WorkbenchHelp.setHelp((Control)targetSelectionComp, (String)"com.aicas.jamaica.eclipse.target");
        this.fTargetSelectionLabel = new Label(targetSelectionComp, 0);
        this.fTargetSelectionLabel.setText("Generate Code for Target: ");
        this.fTargetSelectionCombo = new Combo(targetSelectionComp, 12);
        gd = new GridData(768);
        this.fTargetSelectionCombo.setLayoutData((Object)gd);
        this.fillTargetSelectionCombo();
        this.fTargetSelectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GeneralMainComposite.this.setLaunchConfigName();
            }
        });
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        this.fDirectExecuteCheck = new Button(this.composite, 32);
        this.fDirectExecuteCheck.setText("Download and execute application after build process");
        WorkbenchHelp.setHelp((Control)this.fDirectExecuteCheck, (String)"com.aicas.jamaica.eclipse.directExecute");
        this.fDirectExecuteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GeneralMainComposite.this.visualTarget.updateLaunchConfigurationDialog();
            }
        });
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
    }

    private void fillTargetSelectionCombo() {
        String[] targets = TargetsPage.getTargetNames();
        int i = 0;
        while (i < targets.length) {
            this.fTargetSelectionCombo.add(targets[i]);
            ++i;
        }
    }

    public void setLaunchConfigName() {
        String target = "host";
        try {
            target = JavaProjectTypes.getCurrentConfig().getAttribute("target", "host");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!target.equals(this.fTargetSelectionCombo.getText()) && (JavaProjectTypes.getCurrentConfig().getName().endsWith(target) || JavaProjectTypes.getCurrentConfig().getName().endsWith(")"))) {
            this.setLaunchConfigName(true);
        }
    }

    public void setLaunchConfigName(boolean doSave) {
        String configName = JavaProjectTypes.getCurrentConfig().getName();
        String mainClass = "";
        String target = this.fTargetSelectionCombo.getText();
        try {
            mainClass = JavaProjectTypes.getCurrentConfig().getAttribute(ATTR_MAINCLASSNAME, "New_Application");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        configName = String.valueOf(mainClass) + " for " + target;
        configName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configName);
        JavaProjectTypes.getCurrentConfig().rename(configName);
        if (doSave) {
            try {
                this.visualTarget.updateLaunchConfigurationDialog();
                JavaProjectTypes.getCurrentConfig().doSave();
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IJavaProject getJavaProject() {
        String projectName = "";
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(new Shell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Choose a project to constrain the search for main types");
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
        JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_PROJECTNAME, projectName);
        String projectPath = project.getProject().getLocation().toOSString();
        JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_PROJECTPATH, projectPath);
        this.visualTarget.updateLaunchConfigurationDialog();
    }

    private void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        IJavaSearchScope searchScope = null;
        searchScope = javaProject == null || !javaProject.exists() ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (boolean)false);
        int constraints = 8;
        Shell shell = new Shell();
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        SelectionDialog dialog = JavaUI.createMainTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)searchScope, (int)constraints, (boolean)false, (String)this.fMainText.getText());
        dialog.setTitle("Choose Main Class");
        dialog.setMessage("Choose a main type of your application");
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_MAINCLASSNAME, type.getFullyQualifiedName());
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_PROJECTNAME, javaProject.getElementName());
            this.fProjText.setText(javaProject.getElementName());
            String projectPath = javaProject.getProject().getLocation().toOSString();
            JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_PROJECTPATH, projectPath);
            String programName = type.getElementName();
            JavaProjectTypes.getCurrentConfig().setAttribute(ATTR_PROJECTNAME, programName);
            String destination = String.valueOf(projectPath) + File.separator + programName;
            if (new File(destination).isDirectory()) {
                destination = String.valueOf(projectPath) + File.separator + programName + File.separator + programName;
            }
            this.destinationText.initialize(destination, "on");
            this.classpathText.initialize(this.getBuildClasspath((IJavaElement)javaProject), "on");
            this.setLaunchConfigName(true);
            this.visualTarget.updateLaunchConfigurationDialog();
        }
    }

    private String getBuildClasspath(IJavaElement javaElement) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String projectBuildPaths = "";
        IClasspathEntry[] buildPaths = null;
        try {
            buildPaths = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            System.err.println("JamaicaPlugin: Error getting the project build paths");
        }
        int i = 1;
        while (i < buildPaths.length) {
            projectBuildPaths = String.valueOf(projectBuildPaths) + File.pathSeparator + buildPaths[i].getPath().toOSString();
            ++i;
        }
        String outputLocation = "";
        try {
            outputLocation = javaProject.getOutputLocation().toOSString();
        }
        catch (JavaModelException javaModelException) {
            System.err.println("Jamaica Plugin: Error retrieving project output location");
        }
        int index = outputLocation.indexOf(File.separator, 1);
        outputLocation = index > 1 ? outputLocation.substring(index) : "";
        String projectPath = javaProject.getProject().getLocation().toOSString();
        String projectOutputPath = String.valueOf(projectPath) + outputLocation;
        return String.valueOf(projectOutputPath) + projectBuildPaths;
    }

    public String getMainText() {
        return this.fMainText.getText();
    }

    public String getProjectText() {
        return this.fProjText.getText();
    }

    public void setMainText(String val) {
        this.fMainText.setText(val);
    }

    public void setProjectText(String val) {
        this.fProjText.setText(val);
        projectName = val;
    }

    public void setClasspathText(VisualOption option) {
        this.classpathText = option;
    }

    public void setDestinationText(VisualOption option) {
        this.destinationText = option;
    }

    public String getTargetSelection() {
        return this.fTargetSelectionCombo.getText();
    }

    public void setTargetSelection(String val) {
        this.fTargetSelectionCombo.setText(val);
    }

    public void setDirectExecuteCheck(boolean b) {
        this.fDirectExecuteCheck.setSelection(b);
    }

    public boolean getDirectExecuteCheck() {
        return this.fDirectExecuteCheck.getSelection();
    }
}

