/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.ui.DownloadType;
import com.aicas.jamaica.eclipse.ui.TargetDownloadTab;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FTPComposite
extends DownloadType {
    public static String ATTR_PORT = "ftpPort";
    private TargetDownloadTab targetDownloadTab;
    private ArrayList controls = new ArrayList();
    private Button typeSelection;
    private Text port;
    private Label portLabel;
    private Button verbose;

    public FTPComposite(TargetDownloadTab parentTab) {
        this.targetDownloadTab = parentTab;
    }

    public Composite createControl(Composite comp) {
        this.typeSelection = new Button(comp, 16);
        this.typeSelection.setText("FTP Download");
        try {
            FontData fd = this.typeSelection.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.typeSelection.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.typeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FTPComposite.this.initControls();
                FTPComposite.this.updateLaunchConfigurationDialog();
            }
        });
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        Composite field = new Composite(row, 0);
        gd = new GridData(768);
        field.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        this.portLabel = new Label(field, 0);
        this.portLabel.setText("Port:");
        this.port = new Text(field, 2052);
        gd = new GridData(768);
        this.port.setLayoutData((Object)gd);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                FTPComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.controls.add(this.portLabel);
        this.controls.add(this.port);
        this.verbose = new Button(field, 32);
        this.verbose.setText("Verbose mode");
        gd = new GridData(768);
        this.verbose.setLayoutData((Object)gd);
        this.verbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FTPComposite.this.updateLaunchConfigurationDialog();
            }
        });
        this.verbose.setVisible(false);
        return comp;
    }

    public String getTypeTitle() {
        return "FTP";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ATTR_PORT, "21");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.typeSelection.getSelection()) {
            config.setAttribute("downloadType", "FTP");
        }
        config.setAttribute(ATTR_PORT, this.port.getText());
        config.setAttribute("downloadVerbose", this.verbose.getSelection());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (config.getAttribute("downloadType", "none").equals("FTP")) {
                this.typeSelection.setSelection(true);
            } else {
                this.typeSelection.setSelection(false);
            }
            this.port.setText(config.getAttribute(ATTR_PORT, "21"));
            this.verbose.setSelection(config.getAttribute("downloadVerbose", false));
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from ftp launch config");
            e.printStackTrace();
        }
    }

    protected void updateLaunchConfigurationDialog() {
        this.targetDownloadTab.updateLaunchConfigurationDialog();
    }

    protected void validate() {
    }

    protected void setControlsEnabled(boolean b, boolean includeTitle) {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(b);
        }
        if (includeTitle) {
            this.typeSelection.setEnabled(b);
        }
    }

    protected void setControlsEnabled(boolean b) {
        this.setControlsEnabled(b, false);
    }

    protected void initControls() {
        if (this.typeSelection.getSelection()) {
            this.targetDownloadTab.setGeneralControlsEnabled(true);
            this.setControlsEnabled(true, true);
        } else {
            this.setControlsEnabled(false, false);
            this.typeSelection.setEnabled(true);
        }
    }
}

