/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.ExpectComposite;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExpectDialog
extends TitleAreaDialog {
    private Text textArea;
    private Button template;

    public ExpectDialog(Shell shell) {
        super(shell);
        this.create();
        this.setTitle("Expect Configuration");
        this.setMessage("Define the command sequence to execute the application on your target using the expect command:\n");
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.textArea = new Text(parent, 770);
        try {
            this.textArea.setFont(new Font((Device)this.textArea.getDisplay(), "Courier", 11, 0));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.textArea.setLayoutData((Object)new GridData(1808));
        String s = "";
        try {
            s = TargetSiteAccess.getCurrentConfig().getAttribute(ExpectComposite.ATTR_EXPECT_COMMANDS, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (s.equals("")) {
            s = this.loadTemplateFile("ExpectTemplate.txt");
        }
        s = TargetSiteAccess.replaceSubstring(s, "<br>", "\n");
        this.textArea.setText(s);
        return parent;
    }

    protected void okPressed() {
        TargetSiteAccess.getCurrentConfig().setAttribute(ExpectComposite.ATTR_EXPECT_COMMANDS, TargetSiteAccess.replaceSubstring(this.textArea.getText(), "\n", "<br>"));
        try {
            TargetSiteAccess.getCurrentConfig().doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    private String loadTemplateFile(String filename) {
        StringBuffer btxt;
        block12: {
            String separator = "<br>";
            btxt = new StringBuffer(512);
            BufferedReader rin = null;
            try {
                try {
                    String line;
                    rin = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = rin.readLine()) != null) {
                        if (btxt.length() > 0) {
                            btxt.append(separator);
                        }
                        btxt.append(line);
                    }
                }
                catch (IOException io) {
                    JavaPlugin.log((Throwable)io);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (rin != null) {
                    try {
                        rin.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (rin == null) break block12;
            try {
                rin.close();
            }
            catch (IOException iOException) {}
        }
        return btxt.toString();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.template = this.createButton(composite, 8, "Load Template", false);
        this.template.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String s = ExpectDialog.this.loadTemplateFile("ExpectTemplate.txt");
                s = TargetSiteAccess.replaceSubstring(s, "<br>", "\n");
                ExpectDialog.this.textArea.setText(s);
            }
        });
    }
}

