/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.ExpectRemoteExecution;
import com.aicas.jamaica.eclipse.ui.ExpectDialog;
import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import com.aicas.jamaica.eclipse.ui.TargetRemoteExecutionTab;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExpectComposite
extends RemoteExecutionType {
    private TargetRemoteExecutionTab targetRemoteExecutionTab;
    private ArrayList controls = new ArrayList();
    private Button typeSelection;
    private Button button;
    public static String ATTR_EXPECT_COMMANDS = "expectCommands";

    public ExpectComposite(TargetRemoteExecutionTab parentTab) {
        this.targetRemoteExecutionTab = parentTab;
    }

    public Composite createControl(Composite comp) {
        this.typeSelection = new Button(comp, 16);
        this.typeSelection.setText(this.getTypeTitle());
        try {
            FontData fd = this.typeSelection.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.typeSelection.setFont(new Font((Device)comp.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.typeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpectComposite.this.initControls();
                ExpectComposite.this.updateLaunchConfigurationDialog();
            }
        });
        Composite row = new Composite(comp, 0);
        GridData gd = new GridData(768);
        row.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        row.setLayout((Layout)gl);
        this.button = new Button(row, 8);
        this.button.setText("Edit command sequence...");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExpectComposite.this.openExpectDialog();
            }
        });
        this.controls.add(this.button);
        return comp;
    }

    private void openExpectDialog() {
        ExpectDialog dialog = new ExpectDialog(new Shell());
        dialog.open();
    }

    public String getTypeTitle() {
        return "Expect";
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.typeSelection.getSelection()) {
            config.setAttribute("remoteExecutionType", ExpectRemoteExecution.ID);
        }
        config.setAttribute("configID", config.getName());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (config.getAttribute("remoteExecutionType", "none").equals(ExpectRemoteExecution.ID)) {
                this.typeSelection.setSelection(true);
            } else {
                this.typeSelection.setSelection(false);
            }
        }
        catch (CoreException e) {
            System.err.println("Jamaica Plugin: Error loading values from script launch config");
            e.printStackTrace();
        }
    }

    protected void updateLaunchConfigurationDialog() {
        this.targetRemoteExecutionTab.updateLaunchConfigurationDialog();
    }

    protected void setControlsEnabled(boolean b) {
        this.setControlsEnabled(b, false);
    }

    protected void setControlsEnabled(boolean b, boolean includeTitle) {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            ((Control)iter.next()).setEnabled(b);
        }
        if (includeTitle) {
            this.typeSelection.setEnabled(b);
        }
    }

    protected void initControls() {
        if (this.typeSelection.getSelection()) {
            this.targetRemoteExecutionTab.setGeneralControlsEnabled(true);
            this.setControlsEnabled(true, true);
        } else {
            this.setControlsEnabled(false, false);
            this.typeSelection.setEnabled(true);
        }
    }

    protected void validate() {
        String expectBin;
        if (this.typeSelection.getSelection() && !(expectBin = JamaicaPlugin.getDefault().getPreferenceStore().getString("ExpectBinary")).endsWith("expect") && !expectBin.endsWith("expect.exe") && new File(expectBin).isFile()) {
            this.targetRemoteExecutionTab.setErrorMessage("Expect binary '" + expectBin + "' not found. " + "Please set the correct path in the JamaicaVM Preference Page");
        }
    }
}

