/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.target.ScriptDownload;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.FTPComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;

public abstract class DownloadType {
    public static final String ATTR_TYPE = "downloadType";
    public static final String ATTR_HOST = "downloadHost";
    public static final String ATTR_USERNAME = "downloadUsername";
    public static final String ATTR_PASSWORD = "downloadPassword";
    public static final String ATTR_SMART = "downloadSmart";
    public static final String VARIABLES_INFO = " %h   Host\n %u   Username\n %p   Password\n %f   Absolute path of application (on host)\n %d   Remote directory\n %b   Name of application (on target)\n";
    public static final String NILARG = "<nil>";

    public abstract Composite createControl(Composite var1);

    public abstract String getTypeTitle();

    public abstract void performApply(ILaunchConfigurationWorkingCopy var1);

    public abstract void setDefaults(ILaunchConfigurationWorkingCopy var1);

    public abstract void initializeFrom(ILaunchConfiguration var1);

    protected abstract void updateLaunchConfigurationDialog();

    protected abstract void validate();

    protected abstract void setControlsEnabled(boolean var1);

    protected abstract void setControlsEnabled(boolean var1, boolean var2);

    protected abstract void initControls();

    public static String generateArguments(ILaunchConfiguration config) {
        String host = NILARG;
        String port = NILARG;
        String username = NILARG;
        String password = NILARG;
        String remoteDirectory = NILARG;
        String programName = NILARG;
        String pathBuiltApplication = NILARG;
        String commandScript = "";
        boolean isVerbose = false;
        String type = "";
        try {
            host = config.getAttribute(ATTR_HOST, NILARG);
            port = config.getAttribute(FTPComposite.ATTR_PORT, "21");
            username = config.getAttribute(ATTR_USERNAME, NILARG);
            password = config.getAttribute(ATTR_PASSWORD, NILARG);
            remoteDirectory = config.getAttribute("remoteDirectory", ".");
            programName = config.getAttribute("programName", NILARG);
            pathBuiltApplication = config.getAttribute("pathBuiltApplication", NILARG);
            isVerbose = config.getAttribute("downloadVerbose", false);
            commandScript = config.getAttribute("scriptDownloadCommand", null);
            type = config.getAttribute(ATTR_TYPE, "");
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (host.length() < 1) {
            host = NILARG;
        }
        if (username.length() < 1) {
            username = NILARG;
        }
        if (port.length() < 1) {
            port = "21";
        }
        if (password.length() < 1) {
            password = NILARG;
        }
        if (remoteDirectory.length() < 1) {
            remoteDirectory = NILARG;
        }
        if (programName.length() < 1) {
            programName = NILARG;
        }
        if (pathBuiltApplication.length() < 1) {
            pathBuiltApplication = NILARG;
        }
        String result = "";
        if (type.equals("FTP")) {
            result = String.valueOf(host) + " " + port + " " + username + " " + password + " " + remoteDirectory + " " + programName + " " + pathBuiltApplication + " " + isVerbose;
        } else if (type.equals(ScriptDownload.ID) && commandScript.indexOf(32) > 0) {
            result = commandScript.substring(commandScript.indexOf(32));
        }
        result = TargetSiteAccess.replaceSubstring(result, "%h", host);
        result = TargetSiteAccess.replaceSubstring(result, "%u", username);
        result = TargetSiteAccess.replaceSubstring(result, "%p", password);
        result = TargetSiteAccess.replaceSubstring(result, "%f", pathBuiltApplication);
        result = TargetSiteAccess.replaceSubstring(result, "%d", remoteDirectory);
        result = TargetSiteAccess.replaceSubstring(result, "%b", programName);
        return result;
    }
}

