/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import com.aicas.jamaica.eclipse.target.IRemoteExecution;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import com.aicas.jamaica.eclipse.ui.TelnetComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class TelnetRemoteExecutionUtil
implements IRemoteExecution {
    public static final String ID = "Telnet";
    public static final String TELNET_REMOTE_EXECUTION = "com.aicas.jamaica.eclipse.target.TelnetRemoteExecution";
    public static final String TELNET_INTERACTIVE = "com.aicas.jamaica.eclipse.target.TelnetInteractive";
    public static final String ATTR_VERBOSE = "remoteExecutionVerbose";

    public int launch(ILaunchConfiguration config) {
        boolean isInteractive = false;
        String programName = "";
        try {
            isInteractive = config.getAttribute(TelnetComposite.ATTR_INTERACTIVE, false);
            programName = config.getAttribute("programName", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (isInteractive) {
            String args = this.getInteractiveArguments(config);
            return TargetSiteAccess.launchJavaApplication("Interactive Telnet Session", TELNET_INTERACTIVE, args);
        }
        String args = RemoteExecutionType.generateArguments(config);
        return TargetSiteAccess.launchJavaApplication("Telnet Remote Execution '" + programName + "'", TELNET_REMOTE_EXECUTION, args);
    }

    private String getInteractiveArguments(ILaunchConfiguration config) {
        String host = "<nil>";
        String port = "23";
        String username = "<nil>";
        String password = "<nil>";
        boolean autoLogin = false;
        try {
            host = config.getAttribute("remoteExecutionHost", "<nil>");
            port = config.getAttribute(TelnetComposite.ATTR_PORT, "23");
            username = config.getAttribute("remoteExecutionUername", "<nil>");
            password = config.getAttribute("remoteExecutionPassword", "<nil>");
            autoLogin = config.getAttribute(TelnetComposite.ATTR_INTERACTIVE_AUTOLOGIN, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (host.length() < 1) {
            host = "<nil>";
        }
        if (port.length() < 1) {
            port = "23";
        }
        if (username.length() < 1) {
            username = "<nil>";
        }
        if (password.length() < 1) {
            password = "<nil>";
        }
        return String.valueOf(host) + " " + port + " " + username + " " + password + " " + (autoLogin ? "true" : "false");
    }

    public String getName() {
        return ID;
    }
}

