/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;

public class TelnetRemoteExecution {
    private static TelnetClient telnetClient = new TelnetClient();
    private InputStream in;
    private PrintStream out;
    private static boolean verbose = false;
    public static final String ECHO_ID = "%94ofjERCB";
    private static final String ECHO_COMMAND = "echo %94ofjERCB";

    public TelnetRemoteExecution(String host, String port, String username, String password) {
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("dumb", true, true, true, true);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);
        try {
            telnetClient.addOptionHandler((TelnetOptionHandler)ttopt);
            telnetClient.addOptionHandler((TelnetOptionHandler)gaopt);
        }
        catch (InvalidTelnetOptionException e) {
            System.err.println("Jamaica Plugin:Error registering telnet option handlers: " + e.getMessage());
        }
        if (port.equals("<nil>")) {
            port = "23";
        }
        int p = 23;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Jamaica Plugin: Error in parsing port. Port 23 is used.");
        }
        try {
            if (verbose) {
                System.err.print("Connecting to " + host + ":" + p + " ... ");
            }
            telnetClient.connect(host, p);
            if (verbose) {
                System.err.println("done.");
            }
        }
        catch (IOException iOException) {
            System.err.println("Jamaica Plugin: Error connecting to remote host " + host + ":" + p);
            System.exit(1);
        }
        this.in = telnetClient.getInputStream();
        this.out = new PrintStream(telnetClient.getOutputStream());
        if (username.equals("<nil>")) {
            username = "";
        }
        if (password.equals("<nil>")) {
            password = "";
        }
        if (verbose) {
            System.err.print("Waiting for login prompt... ");
        }
        this.readUntil("ogin:");
        if (verbose) {
            System.err.println("done.");
        }
        this.write(username);
        if (password.length() > 0) {
            if (verbose) {
                System.err.print("Waiting for password prompt... ");
            }
            this.readUntil("assword:");
            if (verbose) {
                System.err.println("done.");
            }
            this.write(password);
        }
        this.readUntil("\n");
    }

    public static void main(String[] args) {
        String host = "<nil>";
        String port = "<nil>";
        String username = "<nil>";
        String password = "<nil>";
        String remoteDir = "<nil>";
        String remoteFile = "<nil>";
        String loadCommand = "<nil>";
        boolean deleteOnExit = false;
        try {
            host = args[0];
            port = args[1];
            username = args[2];
            password = args[3];
            remoteDir = args[4];
            remoteFile = args[5];
            verbose = !args[6].equals("false");
            deleteOnExit = args[7].equals("true");
            loadCommand = args[8];
            int i = 9;
            while (i < args.length) {
                if (args[i].length() > 0) {
                    loadCommand = String.valueOf(loadCommand) + " \"" + args[i] + "\"";
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Jamaica Plugin: ArrayIndexOutOfBounds in program args");
            e.printStackTrace();
        }
        if (verbose) {
            System.err.println("Executing application on target.\n");
        }
        TelnetRemoteExecution telnet = new TelnetRemoteExecution(host, port, username, password);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        telnet.sendCommand("cd " + remoteDir, verbose);
        telnet.sendCommand("chmod 755 " + remoteFile, verbose);
        telnet.sendCommand(loadCommand, true);
        if (deleteOnExit) {
            telnet.sendCommand("rm -f " + remoteFile, verbose);
        }
        telnet.sendCommand(ECHO_COMMAND, true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        telnet.disconnect();
    }

    private String parseID(char firstChar, String id) {
        StringBuffer sb = new StringBuffer();
        sb.append(firstChar);
        int i = 1;
        while (i < id.length()) {
            try {
                sb.append((char)this.in.read());
                if (!id.startsWith(sb.toString())) {
                    return sb.toString();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }

    public String readUntil(String pattern) {
        return this.readUntil(pattern, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readUntil(String pattern, boolean showRespond) {
        try {
            char lastChar = pattern.charAt(pattern.length() - 1);
            StringBuffer sb = new StringBuffer();
            char ch = (char)this.in.read();
            while (true) {
                String s;
                if (showRespond) {
                    if (ch == ECHO_ID.charAt(0)) {
                        s = this.parseID(ch, ECHO_ID);
                        if (s != null) {
                            System.out.print(s);
                        }
                    } else if (ch == 'e') {
                        s = this.parseID(ch, ECHO_COMMAND);
                        if (s == null) return null;
                        System.out.print(s);
                    } else {
                        System.out.print(ch);
                    }
                }
                sb.append(ch);
                if (ch == lastChar) {
                    if (sb.toString().startsWith("\n%94ofjERCB")) {
                        sb = sb.delete(0, 1 + ECHO_ID.length());
                    }
                    if (sb.toString().endsWith(pattern)) {
                        if (!pattern.equals(ECHO_COMMAND)) return sb.toString();
                        s = sb.toString();
                        return s.substring(0, s.length() - ECHO_COMMAND.length());
                    }
                }
                ch = (char)this.in.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(String value) {
        try {
            this.out.println(value);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCommand(String command, boolean showRespond) {
        try {
            this.write(command);
            this.write(ECHO_COMMAND);
            this.readUntil(ECHO_COMMAND, showRespond);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            if (telnetClient.isConnected()) {
                telnetClient.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

