/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetInteractive {
    private TelnetClient telnet = new TelnetClient();
    private InputStream in;
    private PrintStream out;

    public TelnetInteractive(String host, String port, String username, String password, boolean autoLogin) {
        if (host.equals("<nil>")) {
            System.err.println("Jamaica Plugin: Please specify a host name");
            System.exit(1);
        }
        if (port.equals("<nil>")) {
            port = "23";
        }
        int p = 23;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Jamaica Plugin: Error in parsing port. Port 23 is used.");
        }
        try {
            this.telnet.connect(host, p);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.in = this.telnet.getInputStream();
        this.out = new PrintStream(this.telnet.getOutputStream());
        if (autoLogin) {
            if (username.equals("<nil>")) {
                username = "";
            }
            if (password.equals("<nil>")) {
                password = "";
            }
            this.readUntil("ogin:");
            this.write(username);
            if (password.length() > 0) {
                this.readUntil("assword:");
                this.write(password);
            }
        }
    }

    public static void main(String[] args) {
        String host = "<nil>";
        String port = "<nil>";
        String username = "<nil>";
        String password = "<nil>";
        boolean autoLogin = false;
        try {
            host = args[0];
            port = args[1];
            username = args[2];
            password = args[3];
            autoLogin = args[4].equals("true");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Jamaica Plugin: ArrayIndexOutOfBounds in program args");
            e.printStackTrace();
        }
        TelnetInteractive telnetInteractive = new TelnetInteractive(host, port, username, password, autoLogin);
        TelnetInteractive.readWrite(telnetInteractive.getInputStream(), telnetInteractive.getOutputStream(), System.in, System.out);
        try {
            telnetInteractive.getInputStream().close();
            telnetInteractive.getOutputStream().close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.exit(0);
    }

    public static final void readWrite(final InputStream remoteInput, final OutputStream remoteOutput, final InputStream localInput, final OutputStream localOutput) {
        Thread reader = new Thread(){

            public void run() {
                try {
                    int ch;
                    while (!Thread.interrupted() && (ch = localInput.read()) != -1) {
                        remoteOutput.write(ch);
                        remoteOutput.flush();
                    }
                }
                catch (IOException iOException) {}
            }
        };
        Thread writer = new Thread(){

            public void run() {
                try {
                    Util.copyStream((InputStream)remoteInput, (OutputStream)localOutput);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        };
        writer.setPriority(Thread.currentThread().getPriority() + 1);
        writer.start();
        reader.setDaemon(true);
        reader.start();
        try {
            writer.join();
            reader.interrupt();
        }
        catch (InterruptedException interruptedException) {}
    }

    public String readUntil(String pattern) {
        try {
            char lastChar = pattern.charAt(pattern.length() - 1);
            StringBuffer sb = new StringBuffer();
            char ch = (char)this.in.read();
            while (true) {
                System.out.print(ch);
                sb.append(ch);
                if (ch == lastChar && sb.toString().endsWith(pattern)) {
                    return sb.toString();
                }
                ch = (char)this.in.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(String value) {
        try {
            this.out.println(value);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }
}

