/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.FTPDownloadUtil;
import com.aicas.jamaica.eclipse.target.IDownload;
import com.aicas.jamaica.eclipse.target.IRemoteExecution;
import com.aicas.jamaica.eclipse.target.ScriptDownload;
import com.aicas.jamaica.eclipse.target.ScriptRemoteExecution;
import com.aicas.jamaica.eclipse.target.TelnetRemoteExecutionUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;

public class TargetSiteAccess {
    public static final String NONE = "none";
    public static boolean PROGRAM_ON_TARGET_EXISTS = false;
    public static int BUILDER_INSTANCES = 0;
    public static int TARGET_INSTANCES = 0;
    public static final String VAR_HOST = "%h";
    public static final String VAR_USERNAME = "%u";
    public static final String VAR_PASSWORD = "%p";
    public static final String VAR_ARGUMENTS = "%a";
    public static final String VAR_PATH_PROGRAM = "%f";
    public static final String VAR_REMOTE_DIR = "%d";
    public static final String VAR_PROGRAMNAME = "%b";
    private static ILaunchConfigurationWorkingCopy currentConfig;
    private IDownload[] downloadTypes = new IDownload[]{new FTPDownloadUtil(), new ScriptDownload()};
    private IRemoteExecution[] remoteExecutionTypes = new IRemoteExecution[]{new TelnetRemoteExecutionUtil(), new ScriptRemoteExecution()};

    public static void setCurrentConfig(ILaunchConfigurationWorkingCopy config) {
        currentConfig = config;
    }

    public static ILaunchConfigurationWorkingCopy getCurrentConfig() {
        return currentConfig;
    }

    public String[] getDownloadTypes() {
        String[] types = new String[this.downloadTypes.length + 1];
        int i = 0;
        while (i < types.length - 1) {
            types[i] = this.downloadTypes[i].getName();
            ++i;
        }
        types[this.downloadTypes.length] = NONE;
        return types;
    }

    public String[] getRemoteExecutionTypes() {
        String[] types = new String[this.remoteExecutionTypes.length + 1];
        int i = 0;
        while (i < types.length - 1) {
            types[i] = this.remoteExecutionTypes[i].getName();
            ++i;
        }
        types[this.remoteExecutionTypes.length] = NONE;
        return types;
    }

    public static int launchUserScript(String launchName, String location, String args) {
        int exitValue = -1;
        if (location.length() > 0) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            ILaunchConfigurationWorkingCopy wc = null;
            try {
                wc = type.newInstance(null, launchName);
            }
            catch (CoreException coreException) {
                System.err.println("Jamaica Plugin: Error creating working copy of launch configuration");
            }
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
            if (args != null) {
                wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
            }
            try {
                ILaunch launch = wc.launch("run", null);
                while (!launch.isTerminated()) {
                    Thread.sleep(500L);
                }
                exitValue = launch.getProcesses()[0].getExitValue();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Jamaica Plugin: Error executing user script '" + location + "'.");
        }
        return exitValue;
    }

    public static int launchJavaApplication(String launchName, String mainClass, String arguments) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = type.newInstance(null, launchName);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IVMInstallType standardVM = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        IVMInstall[] jres = standardVM.getVMInstalls();
        if (jres.length < 1) {
            System.err.println("Jamaica Plugin: Standard JRE not found. Using default JRE");
        } else {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, jres[0].getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, jres[0].getVMInstallType().getId());
        }
        IPluginDescriptor descriptor = JamaicaPlugin.getDefault().getDescriptor();
        URL installURL = descriptor.getInstallURL();
        String pluginPath = ".";
        String pluginJAR = "jamaica.jar";
        String commonsNetPath = ".";
        String commonsNetJar = "commons-net-1.1.0.jar";
        try {
            URL localURL = Platform.resolve((URL)installURL);
            pluginPath = String.valueOf(localURL.getPath()) + pluginJAR;
            commonsNetPath = String.valueOf(localURL.getPath()) + commonsNetJar;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> classpathList = new ArrayList<String>();
        IClasspathEntry libEntry = JavaCore.newLibraryEntry((IPath)new Path(pluginPath), null, null, (boolean)false);
        RuntimeClasspathEntry runTimeClasspath = new RuntimeClasspathEntry(libEntry);
        String memento = "";
        try {
            memento = runTimeClasspath.getMemento();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        classpathList.add(memento);
        libEntry = JavaCore.newLibraryEntry((IPath)new Path(commonsNetPath), null, null, (boolean)false);
        runTimeClasspath = new RuntimeClasspathEntry(libEntry);
        memento = "";
        try {
            memento = runTimeClasspath.getMemento();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        classpathList.add(memento);
        runTimeClasspath = new RuntimeClasspathEntry(JavaRuntime.getJREVariableEntry());
        try {
            memento = runTimeClasspath.getMemento();
        }
        catch (CoreException e3) {
            e3.printStackTrace();
        }
        classpathList.add(memento);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpathList);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainClass);
        wc.setAttribute(JavaMainTab.ATTR_INCLUDE_EXTERNAL_JARS, true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, arguments);
        int exitValue = -1;
        try {
            ILaunch launch = wc.launch("run", null);
            while (!launch.isTerminated()) {
                Thread.sleep(500L);
            }
            exitValue = launch.getProcesses()[0].getExitValue();
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return exitValue;
    }

    public static String getPathBuiltApplication(ILaunchConfiguration builderConfig) {
        String target = "";
        String targetDest = "";
        String globalDest = "";
        String globalDestState = "";
        String targetDestState = "";
        String programName = "";
        if (builderConfig != null) {
            try {
                globalDest = builderConfig.getAttribute("destination", "");
                target = builderConfig.getAttribute("target", "");
                targetDest = builderConfig.getAttribute("destination." + target, "");
                globalDestState = builderConfig.getAttribute("destination_state", "off");
                targetDestState = builderConfig.getAttribute("destination. " + target + "_state", "off");
                programName = builderConfig.getAttribute("@programName", "");
            }
            catch (CoreException coreException) {
                System.err.println("Jamaica Plugin: Error getting attribute target");
            }
            String s = globalDest.length() > 0 && globalDestState.equals("on") && !targetDestState.equals("on") ? globalDest : (targetDest.length() > 0 && targetDestState.equals("on") ? targetDest : String.valueOf(System.getProperty("user.dir")) + File.separator + programName);
            if ((target.equals("host") || target.startsWith("mingw")) && JamaicaPlugin.getDefault().getPreferenceStore().getString("OS").equals("Windows") && !programName.endsWith(".exe")) {
                s = String.valueOf(s) + ".exe";
            }
            return s;
        }
        return null;
    }

    public static String replaceSubstring(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
}

