/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.IRemoteExecution;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.RemoteExecutionType;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ScriptRemoteExecution
implements IRemoteExecution {
    public static String ID = "Command";

    public int launch(ILaunchConfiguration config) {
        String location = null;
        int exitValue = -1;
        try {
            location = config.getAttribute("scriptRemoteExecutionCommand", null);
            if (location.indexOf(32) > 0) {
                location = location.substring(0, location.indexOf(32));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!location.equals("") && location != null && new File(location).exists()) {
            String args = RemoteExecutionType.generateArguments(config);
            exitValue = TargetSiteAccess.launchUserScript("JamaicaVM Target Site: User Script Remote Execution", location, args);
        } else {
            this.showErrorDialog(String.valueOf(JamaicaPlugin.getResourceString("ErrorMessage_UserScriptDoesNotExist")) + location);
            exitValue = -1;
        }
        return exitValue;
    }

    public String getName() {
        return ID;
    }

    public void showErrorDialog(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Builder", (String)message);
            }
        });
    }
}

