/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamException;

public class FTPDownload {
    private FTPClient ftpClient = new FTPClient();
    private static boolean error = false;
    int reply;

    public FTPDownload(String host, String port, String username, String password) {
        if (port.equals("<nil>")) {
            port = "21";
        }
        int p = 21;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Jamaica Plugin: Error in parsing port. Port 21 is used.");
        }
        try {
            this.ftpClient.connect(host, p);
            System.out.println("Connected to " + host + ":" + port);
            this.reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)this.reply)) {
                this.ftpClient.disconnect();
                System.err.println("FTP server refused connection.");
            }
        }
        catch (IOException e) {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
            System.err.println("Could not connect to server.");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (!this.ftpClient.login(username, password)) {
                this.ftpClient.logout();
                System.err.println("Jamaica Plugin: Could not login to FTP server");
                error = true;
                System.exit(1);
            }
        }
        catch (IOException e) {
            error = true;
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String host = "<nil>";
        String port = "21";
        String username = "<nil>";
        String password = "<nil>";
        String remoteDirectory = "<nil>";
        String programName = "<nil>";
        String pathBuiltApplication = "<nil>";
        try {
            host = args[0];
            port = args[1];
            username = args[2];
            password = args[3];
            remoteDirectory = args[4];
            programName = args[5];
            pathBuiltApplication = args[6];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Jamaica Plugin: ArrayIndexOutOfBounds in program args");
            e.printStackTrace();
        }
        FTPDownload ftpDownload = new FTPDownload(host, port, username, password);
        FTPClient ftpClient = ftpDownload.getFtpClient();
        FTPDownload fTPDownload = ftpDownload;
        fTPDownload.getClass();
        ftpClient.addProtocolCommandListener((ProtocolCommandListener)fTPDownload.new PrintCommandListener(new PrintWriter(System.out)));
        try {
            try {
                System.out.println("Remote system is " + ftpClient.getSystemName());
                ftpClient.setFileType(2);
                ftpClient.enterLocalPassiveMode();
                FileInputStream input = new FileInputStream(pathBuiltApplication);
                ftpClient.sendCommand(3, remoteDirectory);
                if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                    System.err.println("Jamaica Plugin: Error changing to directory '" + remoteDirectory + "'!");
                    System.err.println("Check the entry 'Remote Directory' of your JamaicaVM Target Site Configuration.");
                    if (ftpClient.isConnected()) {
                        try {
                            ftpClient.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                    System.exit(1);
                }
                if (!ftpClient.storeFile(programName, (InputStream)input)) {
                    System.err.println("Jamaica Plugin: Error saving file on target.");
                    error = true;
                }
                ftpClient.logout();
            }
            catch (CopyStreamException cse) {
                System.err.println("Jamaica Plugin: Error while saving file.");
                System.err.println("Disk space required by '" + pathBuiltApplication.substring(pathBuiltApplication.lastIndexOf(File.separatorChar) + 1) + "': " + new File(pathBuiltApplication).length() + " Bytes");
                System.err.println("Transfered so far: " + cse.getTotalBytesTransferred() + " Bytes");
                System.err.println("Not enough free disk space on target!");
                error = true;
            }
            catch (FTPConnectionClosedException e) {
                System.err.println("Server closed connection.");
                error = true;
                e.printStackTrace();
            }
            catch (IOException e) {
                error = true;
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var11_17 = null;
        if (ftpClient.isConnected()) {
            try {
                ftpClient.disconnect();
            }
            catch (IOException iOException) {}
        }
        System.exit(error ? 1 : 0);
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    private class PrintCommandListener
    implements ProtocolCommandListener {
        private PrintWriter __writer;

        public PrintCommandListener(PrintWriter writer) {
            this.__writer = writer;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.__writer.print(event.getMessage());
            this.__writer.flush();
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.__writer.print(event.getMessage());
            this.__writer.flush();
        }
    }
}

