/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.target;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.IRemoteExecution;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.ExpectComposite;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExpectRemoteExecution
implements IRemoteExecution {
    public static String ID = "Expect";

    public String getName() {
        return ID;
    }

    public int launch(ILaunchConfiguration config) {
        String location = JamaicaPlugin.getDefault().getPreferenceStore().getString("ExpectBinary");
        String expectCommands = null;
        int exitValue = -1;
        try {
            expectCommands = config.getAttribute(ExpectComposite.ATTR_EXPECT_COMMANDS, null);
            if (expectCommands == null) {
                return 1;
            }
            expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "<br>", "\n");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String tmpExpectFile = this.createTmpScript(expectCommands, config);
        if (!expectCommands.equals("") && expectCommands != null && new File(location).isFile()) {
            String args = "\"" + tmpExpectFile + "\"";
            exitValue = TargetSiteAccess.launchUserScript("JamaciaVM Target Site: Expect", location, args);
        } else {
            this.showErrorDialog(String.valueOf(JamaicaPlugin.getResourceString("ErrorMessage_ExpectNotFound")) + location);
            exitValue = -1;
        }
        new File(tmpExpectFile).delete();
        return exitValue;
    }

    private String createTmpScript(String expectCommands, ILaunchConfiguration config) {
        String host = "";
        String username = "";
        String password = "";
        String arguments = "";
        String remoteDirectory = "";
        String programName = "";
        String pathBuiltApplication = "";
        try {
            host = config.getAttribute("remoteExecutionHost", "");
            username = config.getAttribute("remoteExecutionUername", "");
            password = config.getAttribute("remoteExecutionPassword", "");
            arguments = config.getAttribute("remoteExecutionArguments", "");
            remoteDirectory = config.getAttribute("remoteDirectory", ".");
            programName = config.getAttribute("programName", "");
            pathBuiltApplication = config.getAttribute("pathBuiltApplication", "");
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%h", host);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%u", username);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%p", password);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%a", arguments);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%f", pathBuiltApplication);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%d", remoteDirectory);
        expectCommands = TargetSiteAccess.replaceSubstring(expectCommands, "%b", programName);
        String tmpExpectFile = System.getProperty("user.home");
        tmpExpectFile = tmpExpectFile.endsWith(File.separator) ? String.valueOf(tmpExpectFile) + ".expect.tmp" : String.valueOf(tmpExpectFile) + File.separator + ".expect.tmp";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(tmpExpectFile));
            out.write(expectCommands);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmpExpectFile;
    }

    public void showErrorDialog(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Target Site", (String)message);
            }
        });
    }
}

