/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.options;

import com.aicas.jamaica.eclipse.Dependency;
import com.aicas.jamaica.eclipse.options.BooleanOption;
import com.aicas.jamaica.eclipse.options.IntegerOption;
import com.aicas.jamaica.eclipse.options.StringOption;
import com.aicas.jamaica.range.BooleanRange;
import com.aicas.jamaica.range.IntegerRange;
import com.aicas.jamaica.range.Range;
import com.aicas.jamaica.range.StringRange;
import java.util.ArrayList;

public abstract class Option {
    private String name;
    private String description;
    private String targetOrGlobal;
    private Range range;
    private Dependency dependency;
    private ArrayList dependendChilds = new ArrayList();

    protected Option(String name, String description, String targetOrGlobal, Range range, Dependency dependency) {
        this.name = name == null ? "<unknown>" : name;
        this.description = description;
        this.targetOrGlobal = targetOrGlobal;
        this.range = range;
        this.dependency = dependency;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTargetOrGlobal() {
        return this.targetOrGlobal;
    }

    public Range getRange() {
        return this.range;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public ArrayList getDependendChilds() {
        return this.dependendChilds;
    }

    public void addDependendChild(Option child) {
        this.dependendChilds.add(child);
    }

    public static Option newInstance(String name, String description, String targetOrGlobal, Range range, Dependency dependency) {
        if (range instanceof BooleanRange) {
            return new BooleanOption(name, description, targetOrGlobal, range, dependency);
        }
        if (range instanceof StringRange) {
            return new StringOption(name, description, targetOrGlobal, range, dependency);
        }
        if (range instanceof IntegerRange) {
            return new IntegerOption(name, description, targetOrGlobal, range, dependency);
        }
        return null;
    }
}

