/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.options;

import com.aicas.jamaica.eclipse.Dependency;
import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.VisualOptionsGroup;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.range.BooleanRange;
import com.aicas.jamaica.range.IntegerRange;
import com.aicas.jamaica.range.StringRange;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;

public class BuilderOptions {
    public static ArrayList mkOptionsPage(Composite parent, VisualTarget tab, int tabType) {
        ArrayList<VisualOptionsGroup> groups = new ArrayList<VisualOptionsGroup>();
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(Option.newInstance("verbose", "-verbose : Verbose mode. ", "GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        if (tabType == VisualTarget.GLOBAL) {
            groups.add(new VisualOptionsGroup(options, tab, tabType, "General"));
        }
        options = new ArrayList();
        options.add(Option.newInstance("classpath", "-classpath <path>: Specifies path used for loading classes. ", "TARGET_OR_GLOBAL", new StringRange(2), Dependency.INDEPENDENT));
        options.add(Option.newInstance("Xbootclasspath", "-Xbootclasspath <path>: Specifies boot class path used for loading system classes. ", "TARGET_OR_GLOBAL", new StringRange(1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("jar", "-jar <JAR-file>: Load the main class from <JAR file>. This needs a MANIFEST with a Main-Class entry.", "TARGET_OR_GLOBAL", new StringRange(4, ".jar"), Dependency.INDEPENDENT));
        options.add(Option.newInstance("includeClasses", "-includeClasses <class/package>: Force inclusion of the listed classes and packages into the application. The listed classes and all their methods and fields will be included even if smart linking is enabled. E.g., -includeClasses \"com.my_company.MyClass:java.util.*:java.lang... \" includes the class com.my_company.MyClas, all classes in package java.util, and all classes in package java.lang and all sub-packages of java.lang such as java.lang.ref etc. ", "TARGET_OR_GLOBAL", new StringRange(10), Dependency.INDEPENDENT));
        options.add(Option.newInstance("destination", "-destination <name>: Name of the executable to be created ", "TARGET_OR_GLOBAL", new StringRange(1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("tmpdir", "-tmpdir <name>: Name of directory for temporary files ", "TARGET_OR_GLOBAL", new StringRange(6), Dependency.INDEPENDENT));
        options.add(Option.newInstance("resource", "-resource <names>: Add the listed resources to the built application. The resources must be ordinary files that can be found in the classpath-directories. The resources can be accessed by the Java application through Class.getResourceAsStream(<name>). Several resources that are specified must be separated by spaces and enclosed in \".", "TARGET_OR_GLOBAL", new StringRange(5), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XnoMain", "-XnoMain : Do not select a main class for the built application. Instead, the first argument of the argument list passed to the application will be interpreted as the main class.", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XnoClasses", "-XnoClasses : Do not include any classes in the built application. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("enableZIP", "-enableZIP : Enable ZIP and JAR support in the generated binary. This makes binaries significantly bigger. Only enable this option if *your* application on the target system might access ZIP and JAR files at runtime. Independently of this option, the Jamaica Builder can always process classes in ZIP or JAR files.", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("ignoreClassNotFound", "-ignoreClassNotFound : If set, this option causes the builder to ignore missing classes. Empty dummy classes are created instead of the missing classes. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("cldc", "-cldc : Use CLDC configuration. Providing this option forces the builder to include all classes, fields, methods and constructors that form part of the CLDC configuration. These will be added to the built application even if smart linking is activated using -smart. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("setLibraries", "-setLibraries <symbol>=<value>{,<value>}|list: Choose set of libraries to be included in the target application if used. Library sets are used  for features such as supported encodings, protocols, locales, etc. A list of available libraries  can be obtained via '-setLibraries list'. Restricting the set of libraries to be included into  the target application can help to reduce the footprint and heap size required by the application E.g. -setLibraries encodings=8859_1,UTF8 sets the set of supported encodings to 8859_1 and UTF8. ", "TARGET_OR_GLOBAL", new StringRange(0), Dependency.INDEPENDENT));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Classes, files and paths"));
        options = new ArrayList();
        options.add(Option.newInstance("smart", "-smart : Link smartly, i.e., remove unused code and perform better optimization. Only use this option on closed systems. See manual for details. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("notSmart", "-notSmart <classes>: Exclude <classes> and all their subclasses from smart linking (needed for reflection to work on these classes and when subclasses are dynamically loaded using a custom ClassLoader). Multiple classes must be separated by spaces and enclosed in \", e. g., -notSmart \"my.Class1 my.Class2\"", "TARGET_OR_GLOBAL", new StringRange(10), new Dependency("smart", new BooleanRange(true), null)));
        options.add(Option.newInstance("numDynamicTypesFromEnv", "-numDynamicTypesFromEnv <var>: Create an application that reads the  number of dynamically loadable types from the environment variable <var>. If this variable is not set, the number  specified using -numDynamicTypes <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), new Dependency("smart", new BooleanRange(true), null)));
        options.add(Option.newInstance("numDynamicTypes", "-numDynamicTypes <n>: Set the number of types that can be used. This number is unlimited unless -smart is set. In smart mode, the number of types (i. e., classes and array types) is limited. If dynamic loading is used in conjunction with -smart, the maximum number of types used by code that is loaded dynamically must be specified using this options. ", "TARGET_OR_GLOBAL", new IntegerRange(0, 65535, 1), new Dependency("smart", new BooleanRange(true), null)));
        options.add(Option.newInstance("showIncludedFeatures", "-showIncludedFeatures : Show all classes, methods and fields that were included into the built application. Any classes, methods or fields removed from the target application through mechanisms such as smart linking (as activated through option -smart) will not be displayed. ", "GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("showExcludedFeatures", "-showExcludedFeatures : Show all classes, methods and fields that where excluded from the built application. Any classes, methods or fields removed from the target application through mechanisms such as smart linking (as activated through option -smart) will be displayed. ", "GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("large", "-large : Force use of large object model. The large object model is required if smart linking is used (see option -smart) for an application that uses reflection. In this case, the large object model does not require specification of the number of dynamic types used by the application (see option -numDynamicTypes). The large object model requires more memory, but it is more flexible than the short ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("noCompaction", "-noCompaction : Disable class file compaction. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Smart linking"));
        options = new ArrayList();
        options.add(Option.newInstance("compile", "-compile : Statically compile ALL classes. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("debug", "-debug : Link with VM in debugging mode. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("inline", "-inline <n>: Set inlining-level. No inlining = 0, max = 10. ", "TARGET_OR_GLOBAL", new IntegerRange(0, 10, 1), new Dependency("compile", new BooleanRange(true), new Dependency("useProfile", new StringRange(4), null))));
        options.add(Option.newInstance("Xtrace", "-Xtrace <level>: Create TRACE-Code. Off = 0, max = 2 ", "TARGET_OR_GLOBAL", new IntegerRange(0, 2, 1), new Dependency("compile", new BooleanRange(true), new Dependency("useProfile", new StringRange(4), null))));
        options.add(Option.newInstance("excludeLongerThan", "-excludeLongerThan <n>: Do not compile methods that are longer than <n> bytecode instructions. This can be used to avoid generation of long routines that some C-compilers cannot handle. ", "TARGET_OR_GLOBAL", new IntegerRange(0, Integer.MAX_VALUE, 1), new Dependency("compile", new BooleanRange(true), new Dependency("useProfile", new StringRange(4), null))));
        options.add(Option.newInstance("optimize", "-optimize <type>: Specify the optimization (none,size,speed,all).", "TARGET", new StringRange(0), new Dependency("debug", new BooleanRange(false), null)));
        options.add(Option.newInstance("Xcc", "-Xcc <cc>: Use the specified C compiler. ", "TARGET", new StringRange(14), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XCFLAGS", "-XCFLAGS <cflags>: Specify the cflags other than optimisation for the invocation of the C compiler. Several flags that are specified must be separated by spaces and enclosed in \". ", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("Xld", "-Xld <linker>: Use the specified linker. ", "TARGET", new StringRange(14), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XLDFLAGS", "-XLDFLAGS <ldflags>: Specify the flags for the C linker.Several flags that are specified must be separated by spaces and enclosed in \". ", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("Xlibraries", "-Xlibraries <libraries>: Link with the specified libraries. Multiple libraries must be separated by spaces and enclosed in \", e. g. -Xlibraries \"m pthread\". ", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XstaticLibraries", "-XstaticLibraries <libraries>: Static link with the specified libraries. This results in a larger executable which is independent of these libraries on the target system. Several libraries that are specified must be separated by spaces and enclosed in \". ", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XlinkDynamicPrefix", "-XlinkDynamicPrefix <prefix>: If the linker is being invoked indirecly via a compiler driver (e. g., gcc), this prefix is used to tell the compiler driver the prefix to use to link a library dynamic to the created executable. For gcc, this prefix is \"-Wl,-Bdynamic -Wl,\". ", "TARGET_OR_GLOBAL", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XlinkStaticPrefix", "-XlinkStaticPrefix <prefix>: If the linker is being invoked indirecly via a compiler driver (e. g., gcc), this prefix is used to tell the compiler driver the prefix to use to link a library statically to the created executable. For gcc, this prefix is \"-Wl,-Bdynamic -Wl,\". ", "TARGET_OR_GLOBAL", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XlibraryPaths", "-XlibraryPaths <libraryPaths>: Add the directories in <libraryPaths> to the library path. Multiple pathes must be separated by spaces and have to be enclosed in \". E. g. -XlibraryPaths \"/usr/local/lib /usr/lib\". ", "TARGET_OR_GLOBAL", new StringRange(8), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XO", "-XO <optflag>: Specify the optimization flags for the C compiler.", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("Xstrip", "-Xstrip <strip>: Use the specified tool for removing debug information. ", "TARGET", new StringRange(14), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XnoRuntimeChecks", "-XnoRuntimeChecks : Disable runtime checks for compiled Java code. This option deactivates checks for null pointer, array index, etc. to obtain better runtime performance. This may be used only for applications that do not cause any runtime checks to fail. The lack of these checks can cause crashes, memory corruption and similar desasters. When untrusted code is executed, disabling these checks can cause vulnerability  through attacks that exploit buffer overflows, type inconsistencies, etc.  ", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XnewTarget", "-XnewTarget <original_target>: Introduce a new (virtual) target which uses the compiled jamaica libraries of <original_target>. E. g., \"-XnewTarget.dilnetpc linux-gnu-i486\" introduces the new target dilnetpc which can have its own settings in the property file, but shares its libraries with the linux-gnu-i486 target.", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Compilation"));
        options = new ArrayList();
        options.add(Option.newInstance("heapSize", "-heapSize <n>: Heap size in bytes. Min=85k. ", "TARGET_OR_GLOBAL", new IntegerRange(87040, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("stackSize", "-stackSize <n>: Stack size in bytes. Min=1k. ", "TARGET_OR_GLOBAL", new IntegerRange(1024, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("javaStackSize", "-javaStackSize <n>: Java stack size in bytes. Minimal size is 1k. ", "TARGET_OR_GLOBAL", new IntegerRange(1024, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("nativeStackSize", "-nativeStackSize <n>: C stack size in bytes. A size of 0 means 'umlimited' stack size. ", "TARGET_OR_GLOBAL", new IntegerRange(0, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("immortalMemorySize", "-immortalMemorySize <n>: Size in bytes of immortal memory available through javax.realtime.ImmortalMemory class. ", "TARGET_OR_GLOBAL", new IntegerRange(0, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("numThreads", "-numThreads <n>: Number of threads. Min=1. ", "TARGET_OR_GLOBAL", new IntegerRange(1, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("analyse", "-analyse <tolerance>: Enable memory analyse mode with an tolerance given in percent. The resulting heap measurement will be at most tolerance per cent larger than the actual heap required by the application. Set tolerance to 0 disables analyse mode off. ", "TARGET_OR_GLOBAL", new IntegerRange(0, 100, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("constGCwork", "-constGCwork <gc-work>: Enable static GC progress with given gc-work per allocation. <3 means off. ", "TARGET_OR_GLOBAL", new IntegerRange(0, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("timeSlice", "-timeSlice <n>: Set length of time slice used for round robin scheduling of threads of equal priorities. The length of the time slice must be given in nanoseconds. A time slice size of 0 indicates that no round robin scheduling is needed for threads of equal priority. In this case, no synchronization thread will be created. Min = 0. ", "TARGET_OR_GLOBAL", new IntegerRange(0, 1000000000, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("finalizerPri", "-finalizerPri <pri>: Set the Java priority of the finalizer thread to <pri>. A priority of 0 indicates that no finalizer thread shall be created. Min = 0, Max = 10. ", "TARGET_OR_GLOBAL", new IntegerRange(0, 10, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("threadPreemption", "-threadPreemption <n>: Allow thread preemption at least all <n> intermediate instructions. One intermediate instruction corresponds to 1-2 machine instructions. Min = 10. ", "TARGET_OR_GLOBAL", new IntegerRange(10, Integer.MAX_VALUE, 1), Dependency.INDEPENDENT));
        options.add(Option.newInstance("strictRTSJ", "-strictRTSJ : Strictly adhere to the Real-Time Spec for Java. If this is eneabled, runtime checks that are not needed by JamaicaVM will be performed. These runtime checks ensure that only RealtimeThreads can enter scoped memory areas and that javax.realtime.NoHeapRealtimeThreads cannot access any objects stored on the Java heap. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("heapSizeFromEnv", "-heapSizeFromEnv <var>: Create an application that reads its heap size from the environment variable <var>. If this variable is not set, the heap size specified using -heapSize <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("stackSizeFromEnv", "-stackSizeFromEnv <var>: Create an application that reads its stack size from the environment variable <var>. If this variable is not set, the stack size specified using -stackSize <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("javaStackSizeFromEnv", "-javaStackSizeFromEnv <var>: Create an application that reads its Java stack size from the environment variable <var>. If this variable is not set, the stack size specified using -javaStackSize <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("nativeStackSizeFromEnv", "-nativeStackSizeFromEnv <var>: Create an application that reads its native stack size from the environment variable <var>. If this variable is not set, the stack size specified using -nativeStackSize <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("immortalMemorySizeFromEnv", "-immortalMemorySizeFromEnv <var>: Create an application that reads its immortal memory size from the environment variable <var>. If this variable is not set, the immortal  memory size specified using -immortalMemorySize <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("numThreadsFromEnv", "-numThreadsFromEnv <var>: Create an application that reads the number of threads from the environment variable <var>. If this variable is not set, the number of threads specified using -numThreads <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("analyseFromEnv", "-analyseFromEnv <var>: Create an application that reads the analyse accuracy from the environment variable <var>. If this variable is not set, the number specified using -analyse <n> will be used. A value of zero enables dynamic mode. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("constGCworkFromEnv", "-constGCworkFromEnv <var>: Create an application that reads the static GC progress from the environment variable <var>. If this variable is not set, the number specified using -constGCwork <n> will be used. ", "TARGET_OR_GLOBAL", new StringRange(12), Dependency.INDEPENDENT));
        options.add(Option.newInstance("priMap", "-priMap <jp=sp{,jp=sp}>: Specify the mapping of Java thread priorities to target system priorities. The Java priorities 1 through 10 correspond to the ten priority levels of java.lang.Thread threads, while priorities higher than 11 represent at least 28 priority levels of javax.realtime.RealtimeThread threads. The highest priority is not available for Java threads, it is used for the synchronization thread that permits round robin scheduling of threads of equal priorities. At least 39 Java priorities have to be specified. If more priorities are defined, the number of priorities available to realtime threads will be higher.ex. \"-priMap 1..11=50,12..39=51..78,40=85\" will cause all java.lang.Thread threads to use system priority 50, while the realtime threads will be mapped to priorities 51 through 78 and the synchronization thread will use priority 85.", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("physicalMemoryRanges", "-physicalMemoryRanges <range{,range}>: Give a list of physical memory ranges that can be accessed by the application. Each memory range is a pair of start and end addresses separated by \"..\". Example: to allow access to memory at the base address 0x0c00 of size 0x0400, use \"-physicalMemoryRanges=3072..4096\".", "TARGET", new StringRange(0), Dependency.INDEPENDENT));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Memory and threads"));
        options = new ArrayList();
        options.add(Option.newInstance("profile", "-profile : Enable profiling (does not work when \"-compile\" set). ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), new Dependency("useProfile", new StringRange(13), null)));
        options.add(Option.newInstance("percentageCompiled", "-percentageCompiled <n>: with -useProfile set, only the <n>% most frequently executed methods are compiled. ", "TARGET_OR_GLOBAL", new IntegerRange(1, 100, 1), new Dependency("useProfile", new StringRange(4), null)));
        options.add(Option.newInstance("useProfile", "-useProfile <p>: Use profiling information from file <p> to restrict compilation to the most popular methods in the profile. The percentage used is 10 if -percentageCompiled is not given. ", "TARGET_OR_GLOBAL", new StringRange(4), new Dependency("profile", new BooleanRange(false), null)));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Profiling"));
        options = new ArrayList();
        options.add(Option.newInstance("object", "-object <files>: Add object files <files> with native code to be linked to the destination executable. Multiple objects must be separated by spaces and enclosed in \". ", "TARGET", new StringRange(5), Dependency.INDEPENDENT));
        options.add(Option.newInstance("include", "-include <dirs>: Add <dirs> to the include path. Multiple directories must be separated by spaces and enclosed in \". ", "TARGET_OR_GLOBAL", new StringRange(8), Dependency.INDEPENDENT));
        options.add(Option.newInstance("Xstats", "-Xstats : Show compact classfile statistics. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XcountCalls", "-XcountCalls : Count calls and print statistics after execution. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XcountArrays", "-XcountArrays : Count array accesses and allocations and print statistics after execution. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XcountAllocs", "-XcountAllocs : Count allocations for arrays and objects. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XcountFields", "-XcountFields : Count accesses to fields. ", "TARGET_OR_GLOBAL", new BooleanRange(true, false), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XobjectFormat", "-XobjectFormat <none|ELF>: Set the object format, e. g. 'none' or 'ELF'. ", "TARGET_OR_GLOBAL", new StringRange(0), Dependency.INDEPENDENT));
        options.add(Option.newInstance("XobjectGenerateCode", "-XobjectGenerateCode <C|i386|i486|i586|sparc>: Set the type of generated code in output object, e. g. 'C', 'i386' or 'sparc. ", "TARGET_OR_GLOBAL", new StringRange(0), Dependency.INDEPENDENT));
        groups.add(new VisualOptionsGroup(options, tab, tabType, "Native code"));
        return groups;
    }
}

