/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launching;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.ExpectRemoteExecution;
import com.aicas.jamaica.eclipse.target.FTPDownloadUtil;
import com.aicas.jamaica.eclipse.target.ScriptDownload;
import com.aicas.jamaica.eclipse.target.ScriptRemoteExecution;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.target.TelnetRemoteExecutionUtil;
import com.aicas.jamaica.eclipse.ui.TelnetComposite;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;

public class TargetSiteLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String ATTR_NEEDS_DOWNLOAD = "needsDownload";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String downloadType = "none";
        String remoteExecutionType = "none";
        String pathBuiltApplication = "";
        String target = "host";
        boolean isSmartDownload = true;
        boolean needsDownload = true;
        boolean deleteOnExit = false;
        final IPreferenceStore store = JamaicaPlugin.getDefault().getPreferenceStore();
        if (TargetSiteAccess.TARGET_INSTANCES > 0) {
            store.setDefault("EXIT_LAUNCH_OF_TARGET_CONFIG", false);
            boolean showWarning = store.getBoolean("WARN_ON_RUNNING_TARGET_CONFIG");
            if (showWarning) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        String message = JamaicaPlugin.getResourceString("Warning_TargetConfigRunning");
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion((Shell)new Shell(), (String)"JamaicaVM Target Site", (String)message, (String)"Do not ask me again", (boolean)false);
                        store.setValue("WARN_ON_RUNNING_TARGET_CONFIG", !dialog.getToggleState());
                        store.setValue("EXIT_LAUNCH_OF_TARGET_CONFIG", dialog.getReturnCode() == 1);
                    }
                });
            }
            if (store.getBoolean("EXIT_LAUNCH_OF_TARGET_CONFIG")) {
                return;
            }
        }
        try {
            downloadType = config.getAttribute("downloadType", "none");
            remoteExecutionType = config.getAttribute("remoteExecutionType", "none");
            pathBuiltApplication = config.getAttribute("pathBuiltApplication", "");
            target = config.getAttribute("target", "host");
            isSmartDownload = config.getAttribute("downloadSmart", true);
            needsDownload = config.getAttribute(ATTR_NEEDS_DOWNLOAD, true);
            deleteOnExit = config.getAttribute(TelnetComposite.ATTR_DELETE_ON_EXIT, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!new File(pathBuiltApplication).exists()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Target Site", (String)JamaicaPlugin.getResourceString("ErrorMessage_NoBuilderConfigForTargetYet"));
                }
            });
            return;
        }
        if (target.equals("host")) {
            this.runOnLocalhost(config);
            return;
        }
        if (downloadType.equals("FTP") || remoteExecutionType.equals("Telnet")) {
            String downloadHost = null;
            String executeHost = null;
            try {
                downloadHost = config.getAttribute("downloadHost", null);
                executeHost = config.getAttribute("remoteExecutionHost", null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if ((downloadType.equals("FTP") || remoteExecutionType.equals("Telnet")) && (downloadHost == null || downloadHost.length() < 1 || executeHost == null || executeHost.length() < 1)) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Target Site", (String)JamaicaPlugin.getResourceString("ErrorMessage_InvalidTargetConfig"));
                    }
                });
                return;
            }
        }
        if (isSmartDownload && TargetSiteAccess.PROGRAM_ON_TARGET_EXISTS) {
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                wc.setAttribute(ATTR_NEEDS_DOWNLOAD, false);
                config = wc.doSave();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            needsDownload = true;
        }
        final String downloadTypeFinal = downloadType;
        final String remoteExecutionTypeFinal = remoteExecutionType;
        final ILaunchConfiguration configFinal = config;
        final boolean needsDownloadFinal = needsDownload;
        final boolean deleteOnExitFinal = deleteOnExit;
        new Thread(new Runnable(){

            public void run() {
                int exitValue = 0;
                ++TargetSiteAccess.TARGET_INSTANCES;
                if (!downloadTypeFinal.equals("none") && needsDownloadFinal) {
                    if (downloadTypeFinal.equals("FTP")) {
                        exitValue = new FTPDownloadUtil().launch(configFinal);
                    } else if (downloadTypeFinal.equals(ScriptDownload.ID)) {
                        exitValue = new ScriptDownload().launch(configFinal);
                    }
                    if (exitValue != 0) {
                        try {
                            configFinal.getWorkingCopy().setAttribute(TargetSiteLaunchConfigurationDelegate.ATTR_NEEDS_DOWNLOAD, true);
                            configFinal.getWorkingCopy().doSave();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!remoteExecutionTypeFinal.equals("none") && (exitValue == 0 && needsDownloadFinal || !needsDownloadFinal)) {
                    if (remoteExecutionTypeFinal.equals("Telnet")) {
                        new TelnetRemoteExecutionUtil().launch(configFinal);
                    } else if (remoteExecutionTypeFinal.equals(ExpectRemoteExecution.ID)) {
                        new ExpectRemoteExecution().launch(configFinal);
                    } else if (remoteExecutionTypeFinal.equals(ScriptRemoteExecution.ID)) {
                        new ScriptRemoteExecution().launch(configFinal);
                    }
                    TargetSiteAccess.PROGRAM_ON_TARGET_EXISTS = !deleteOnExitFinal;
                }
                if (--TargetSiteAccess.TARGET_INSTANCES < 0) {
                    TargetSiteAccess.TARGET_INSTANCES = 0;
                }
            }
        }).start();
    }

    private void runOnLocalhost(ILaunchConfiguration targetConfig) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType externalToolsConfigType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = null;
        String path = "";
        String arguments = "";
        try {
            path = targetConfig.getAttribute("pathBuiltApplication", "");
            arguments = targetConfig.getAttribute("remoteExecutionArguments", "");
            String launchConfigName = manager.generateUniqueLaunchConfigurationNameFrom(new Path(path).lastSegment());
            wc = externalToolsConfigType.newInstance(null, launchConfigName);
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error creating working copy of launch configuration");
        }
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", path);
        if (arguments.length() > 0) {
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
        if (path.length() < 1) {
            System.err.println("Jamaica Plugin: Error launching application as external tool");
        }
        try {
            wc.launch("run", null);
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error launching target site launch configuration \"" + targetConfig.getName() + "\"");
        }
    }
}

