/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launching;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.launching.BuildRunner;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;

public class BuilderLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private static final char ARG_DELIMITER = ' ';
    private static final char ARG_DBL_QUOTE = '\"';
    private static final char VAR_TAG_START_CHAR1 = '$';
    private static final char VAR_TAG_START_CHAR2 = '{';
    private static final char VAR_TAG_END_CHAR1 = '}';
    public static final String ATTR_CONFIGURATION = "@configurationFile";
    private static boolean isWindows;

    public BuilderLaunchConfigurationDelegate() {
        isWindows = JamaicaPlugin.getDefault().getPreferenceStore().getString("OS").equals("Windows");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (TargetSiteAccess.BUILDER_INSTANCES > 0) {
            final IPreferenceStore store = JamaicaPlugin.getDefault().getPreferenceStore();
            store.setDefault("EXIT_LAUNCH_OF_BUILDER_CONFIG", false);
            boolean showWarning = store.getBoolean("WARN_ON_RUNNING_BUILDER_CONFIG");
            if (showWarning) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        String message = JamaicaPlugin.getResourceString("Warning_BuilderConfigRunning");
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openQuestion((Shell)new Shell(), (String)"JamaicaVM Builder", (String)message, (String)"Do not ask me again", (boolean)false);
                        store.setValue("WARN_ON_RUNNING_BUILDER_CONFIG", !dialog.getToggleState());
                        store.setValue("EXIT_LAUNCH_OF_BUILDER_CONFIG", dialog.getReturnCode() == 1);
                    }
                });
            }
            if (store.getBoolean("EXIT_LAUNCH_OF_BUILDER_CONFIG")) {
                return;
            }
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        JavaProjectTypes.setCurrentConfig(wc);
        DebugUIPlugin.saveAndBuild();
        monitor.setTaskName("Initializing JamaicaVM Builder...");
        String jamaicaHome = JamaicaPlugin.getDefault().getPreferenceStore().getString("JamaicaHome");
        IPath location = isWindows ? this.getLocation("jamaica.cmd", jamaicaHome) : this.getLocation("jamaica", jamaicaHome);
        String args = this.generateOptions(wc);
        String[] arguments = this.parseArgumentsIntoList(args);
        try {
            wc.doSave();
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        int cmdLineLength = 1;
        if (arguments != null) {
            cmdLineLength += arguments.length;
        }
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = location.toOSString();
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        if (monitor.isCanceled() && --TargetSiteAccess.BUILDER_INSTANCES < 0) {
            TargetSiteAccess.BUILDER_INSTANCES = 0;
        }
        Process p = DebugPlugin.exec((String[])cmdLine, null);
        IProcess process = null;
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = location.lastSegment();
        String extension = location.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        if (p != null) {
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)location.toOSString(), processAttributes);
        }
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        BuildRunner runner = new BuildRunner(process, monitor, configuration);
        Thread t = new Thread(runner);
        t.start();
    }

    private Hashtable filterOptions(Map map, String target) {
        Hashtable<String, String> options = new Hashtable<String, String>();
        String key = "";
        String value = "";
        String state = "";
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            key = (String)itr.next();
            if (key.indexOf(".") >= 0 && !key.endsWith(target) || key.endsWith("_state") || key.startsWith("@")) continue;
            value = (String)map.get(key);
            if (!map.containsKey(String.valueOf(key) + "_state")) continue;
            state = (String)map.get(String.valueOf(key) + "_state");
            if (state.equals("on")) {
                options.put(key, value);
                continue;
            }
            if (!state.equals("global")) continue;
            String globalKey = key.substring(0, key.indexOf(46));
            String globalValue = (String)map.get(globalKey);
            String globalState = (String)map.get(String.valueOf(globalKey) + "_state");
            if (!globalState.equals("on") || globalValue.length() <= 0) continue;
            options.put(key, globalValue);
        }
        return options;
    }

    private String generateOptions(ILaunchConfigurationWorkingCopy wc) {
        Map map = null;
        try {
            map = wc.getAttributes();
        }
        catch (CoreException coreException) {
            System.err.println("Jamacia Plugin: Error getting attributes of launch configuration");
        }
        String targetname = (String)map.get("target");
        Hashtable relevantOptions = new Hashtable();
        relevantOptions = this.filterOptions(map, targetname);
        Properties builderOptions = new Properties();
        builderOptions.putAll((Map<?, ?>)relevantOptions);
        builderOptions.put("main", (String)map.get("@mainClassName"));
        String configurationFile = (String)map.get("@projectPath");
        configurationFile = configurationFile.endsWith(File.separator) ? String.valueOf(configurationFile) + builderOptions.getProperty("main", "") + ".buildConfig" : String.valueOf(configurationFile) + File.separator + builderOptions.getProperty("main", "") + ".buildConfig";
        wc.setAttribute(ATTR_CONFIGURATION, configurationFile);
        FileOutputStream cfgstream = null;
        try {
            cfgstream = new FileOutputStream(configurationFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Jamacia Plugin: Error loading map properties file with builder options :" + (configurationFile == null ? "File is null" : configurationFile));
        }
        try {
            builderOptions.store(cfgstream, "JamaicaVM Builder Configuration for " + (String)map.get("@mainClassName"));
            cfgstream.close();
        }
        catch (IOException iOException) {
            System.err.println("Jamacia Plugin: Error loading properties from " + configurationFile);
        }
        String builderCallString = "-configuration=\"" + configurationFile + "\"";
        builderCallString = this.appendSystemProperties(builderCallString);
        return builderCallString;
    }

    private String appendSystemProperties(String optionString) {
        optionString = String.valueOf(optionString) + " -Djamaica.home=\"" + JamaicaPlugin.getDefault().getPreferenceStore().getString("JamaicaHome") + "\"";
        String projectPath = "";
        try {
            projectPath = JavaProjectTypes.getCurrentConfig().getAttribute("@projectPath", "");
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error getting Attribute for project path");
        }
        optionString = String.valueOf(optionString) + " -Djamaica.project=\"" + projectPath + "\"";
        return optionString;
    }

    private IPath getLocation(String programName, String jamaicaHome) {
        File file = new File(jamaicaHome = !jamaicaHome.endsWith(File.separator) ? String.valueOf(jamaicaHome) + File.separator + "bin" + File.separator + programName : String.valueOf(jamaicaHome) + "bin" + File.separator + programName);
        if (file.isFile()) {
            return new Path(jamaicaHome);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Builder", (String)JamaicaPlugin.getResourceString("ErrorMessage_JamaicaBinNotFound"));
            }
        });
        return null;
    }

    private String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(' ');
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    private String[] parseArgumentsIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(10);
        boolean inQuotes = false;
        boolean inVar = false;
        int start = 0;
        int end = arguments.length();
        StringBuffer buffer = new StringBuffer(end);
        block6: while (start < end) {
            char ch = arguments.charAt(start);
            ++start;
            switch (ch) {
                case ' ': {
                    if (inQuotes || inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (buffer.length() <= 0) continue block6;
                    list.add(buffer.toString());
                    buffer.setLength(0);
                    break;
                }
                case '\"': {
                    if (inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (start < end) {
                        if (arguments.charAt(start) == '\"') {
                            buffer.append(ch);
                            ++start;
                            break;
                        }
                        inQuotes = !inQuotes;
                        break;
                    }
                    inQuotes = false;
                    break;
                }
                case '$': {
                    buffer.append(ch);
                    if (inVar || start >= end || arguments.charAt(start) != '{') continue block6;
                    buffer.append('{');
                    inVar = true;
                    ++start;
                    break;
                }
                case '}': {
                    buffer.append(ch);
                    inVar = false;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }
}

