/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launching;

import com.aicas.jamaica.eclipse.JamaicaConfSettings;
import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.ui.TargetsPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodFinder;
import org.eclipse.jdt.internal.debug.ui.launcher.MainTypeSelectionDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class BuilderDefaultsShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void searchAndLaunch(Object[] search, String mode, boolean editor) {
        IType[] types = null;
        if (search != null) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                types = MainMethodFinder.findTargets((IRunnableContext)dialog, (Object[])search);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Launch failed", (String)e.getMessage());
                return;
            }
            IType type = null;
            if (types.length == 0) {
                String message = null;
                message = editor ? "The active editor does not contain a main type." : "The selection does not contain a main type.";
                MessageDialog.openError((Shell)this.getShell(), (String)"Launch failed", (String)message);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(this.getShell(), types);
        if (mode.equals("debug")) {
            dialog.setTitle("Type Selection Debug");
        } else {
            dialog.setTitle("Main Type Selection Jamaica Builder");
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        ILaunchConfiguration config;
        String target = this.chooseTarget();
        if (target != null && (config = this.createConfiguration(type, target)) != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected String chooseTarget() {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])TargetsPage.getTargetNames());
        dialog.setTitle("Target selection");
        dialog.setMessage("Choose a target");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (String)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type, String target) {
        String configName = null;
        configName = String.valueOf(type.getFullyQualifiedName()) + " for " + target;
        configName = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configName);
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getBuilderLaunchConfigType();
            wc = configType.newInstance(null, configName);
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttributes(new JamaicaConfSettings().getDefaultsMap());
        new JavaProjectTypes().initializeProjectTypes(wc);
        String projectName = "";
        try {
            projectName = wc.getAttribute("@projectName", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (projectName.indexOf(" ") != -1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Jamaica Builder", (String)"Java projects to be used with Jamaica must\nnot contain spaces in the project name.\n\nPlease rename your project using 'Refactor->Rename...'.");
            return null;
        }
        wc.setAttribute("@mainClassName", type.getFullyQualifiedName());
        wc.setAttribute("@programName", type.getElementName());
        wc.setAttribute("target", target);
        wc.setAttribute("@directExecute", false);
        JavaProjectTypes.setCurrentConfig(wc);
        try {
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected void reportCreatingConfiguration(final CoreException exception) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)BuilderDefaultsShortcut.this.getShell(), (String)"Error Launching", (String)"Jamaica Builder Launch Shortcut Exception", (IStatus)exception.getStatus());
            }
        });
    }

    protected ILaunchConfigurationType getBuilderLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.aicas.jamaica.eclipse.launching.jamaicaBuilder");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode, true);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Launch failed", (String)"The active editor does not contain a main type.");
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, false);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Launch failed", (String)"The selection does not contain a main type.");
        }
    }
}

