/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launching;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.target.TargetSiteAccess;
import com.aicas.jamaica.eclipse.ui.FTPComposite;
import com.aicas.jamaica.eclipse.ui.TelnetComposite;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BuildRunner
implements Runnable {
    private IProcess process;
    private IProgressMonitor monitor;
    private ILaunchConfiguration builderConfig;

    public BuildRunner(IProcess p, IProgressMonitor mon, ILaunchConfiguration config) {
        this.process = p;
        this.monitor = mon;
        this.builderConfig = config;
    }

    public void run() {
        ++TargetSiteAccess.BUILDER_INSTANCES;
        while (!this.process.isTerminated()) {
            try {
                if (this.monitor.isCanceled()) {
                    this.process.terminate();
                    break;
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                --TargetSiteAccess.BUILDER_INSTANCES;
                System.err.println("Jamaica Plugin: Error in Build Runner");
                e.printStackTrace();
            }
            catch (DebugException e) {
                --TargetSiteAccess.BUILDER_INSTANCES;
                System.err.println("Jamaica Plugin: Error in Build Runner");
                e.printStackTrace();
            }
        }
        --TargetSiteAccess.BUILDER_INSTANCES;
        int exitValue = -1;
        try {
            exitValue = this.process.getExitValue();
        }
        catch (DebugException e1) {
            --TargetSiteAccess.BUILDER_INSTANCES;
            System.err.println("Jamaica Plugin: Error getting exit value of build process");
            e1.printStackTrace();
        }
        if (exitValue == 0) {
            String target = "host";
            String programName = "Application";
            try {
                target = this.builderConfig.getAttribute("target", "host");
                programName = this.builderConfig.getAttribute("@programName", "<none>");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ILaunchConfiguration targetConfig = this.checkForTargetSiteConfig(target, programName);
            if (targetConfig != null) {
                try {
                    this.setUpTargetConfig(targetConfig);
                    if (this.canLaunchTargetSiteConfig(targetConfig)) {
                        targetConfig.launch("run", null);
                    }
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
            }
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)new Shell(), (String)"JamaicaVM Builder", (String)JamaicaPlugin.getResourceString("ErrorMessage_LaunchingBuilder"));
                }
            });
            return;
        }
        String configuration = null;
        try {
            configuration = this.builderConfig.getAttribute("@configurationFile", null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (configuration != null && new File(configuration).isFile()) {
            new File(configuration).delete();
        }
        String projectName = null;
        try {
            projectName = this.builderConfig.getAttribute("@projectName", null);
        }
        catch (CoreException e3) {
            e3.printStackTrace();
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
        try {
            if (resource != null) {
                resource.refreshLocal(2, null);
            }
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
    }

    private void setUpTargetConfig(ILaunchConfiguration targetConfig) {
        boolean useGlobalProgramName = true;
        try {
            useGlobalProgramName = targetConfig.getAttribute("useGlobalProgramName", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = targetConfig.getWorkingCopy();
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (!useGlobalProgramName) {
            String destinationName = TargetSiteAccess.getPathBuiltApplication(this.builderConfig);
            Path path = new Path(destinationName);
            wc.setAttribute("programName", path.lastSegment());
        }
        wc.setAttribute("needsDownload", true);
        try {
            targetConfig = wc.doSave();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private ILaunchConfiguration checkForTargetSiteConfig(String target, String programName) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.aicas.jamaica.eclipse.launching.jamaicaTargetSite");
        ILaunchConfiguration[] targetConfigs = null;
        try {
            targetConfigs = manager.getLaunchConfigurations(type);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ILaunchConfiguration matchingTargetConfig = null;
        String tmpTarget = "";
        int i = 0;
        while (i < targetConfigs.length) {
            try {
                tmpTarget = targetConfigs[i].getAttribute("target", "");
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            if (tmpTarget.equals(target) && targetConfigs[i].getName().startsWith(programName)) {
                matchingTargetConfig = targetConfigs[i];
                break;
            }
            ++i;
        }
        if (matchingTargetConfig == null) {
            return this.createTargetSiteConfig(target, programName);
        }
        return this.updateTargetSiteConfig(matchingTargetConfig);
    }

    private ILaunchConfiguration updateTargetSiteConfig(ILaunchConfiguration matchingTargetConfig) {
        ILaunchConfiguration updatedConfig = null;
        String pathBuiltApplication = "";
        String target = "";
        pathBuiltApplication = TargetSiteAccess.getPathBuiltApplication(this.builderConfig);
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = matchingTargetConfig.getWorkingCopy();
            target = wc.getAttribute("target", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        wc.setAttribute("pathBuiltApplication", pathBuiltApplication);
        String programName = new Path(pathBuiltApplication).lastSegment();
        String configName = wc.getName();
        if (configName.endsWith("on " + target)) {
            configName = String.valueOf(programName) + " on " + target;
        }
        configName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configName);
        wc.rename(configName);
        try {
            updatedConfig = wc.doSave();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return updatedConfig;
    }

    private ILaunchConfiguration createTargetSiteConfig(String target, String programName) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.aicas.jamaica.eclipse.launching.jamaicaTargetSite");
        String configName = String.valueOf(programName) + " on " + target;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = type.newInstance(null, configName);
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error creating working copy of target site launch configuration");
        }
        wc.setAttribute("target", target);
        if (target.equals("host")) {
            wc.setAttribute("downloadType", "none");
            wc.setAttribute("remoteExecutionType", "none");
        } else {
            wc.setAttribute("remoteDirectory", ".");
            wc.setAttribute("downloadType", "FTP");
            wc.setAttribute("remoteExecutionType", "Telnet");
        }
        wc.setAttribute(FTPComposite.ATTR_PORT, "21");
        wc.setAttribute(TelnetComposite.ATTR_PORT, "23");
        wc.setAttribute(TelnetComposite.ATTR_LOAD_COMMAND, "." + File.separator + "%b" + " " + "%a");
        wc.setAttribute("pathBuiltApplication", TargetSiteAccess.getPathBuiltApplication(this.builderConfig));
        ILaunchConfiguration config = null;
        try {
            config = wc.doSave();
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error saving target site launch configuration to file");
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)new Shell(), (String)"JamaicaVM Target Site", (String)JamaicaPlugin.getResourceString("InfoMessage_ConfigForTargetCreated"));
            }
        });
        return config;
    }

    private boolean canLaunchTargetSiteConfig(ILaunchConfiguration targetConfig) {
        boolean isDirectLaunch = false;
        String downloadHost = null;
        String executeHost = null;
        try {
            isDirectLaunch = this.builderConfig.getAttribute("@directExecute", false);
            downloadHost = targetConfig.getAttribute("downloadHost", null);
            executeHost = targetConfig.getAttribute("remoteExecutionHost", null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (downloadHost == null || downloadHost.length() < 1 || executeHost == null || executeHost.length() < 1) {
            return false;
        }
        return isDirectLaunch;
    }
}

