/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.jamaicavm;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public abstract class JavaVMRunner
extends AbstractVMRunner {
    protected IVMInstall fVMInstance;

    public JavaVMRunner(IVMInstall vmInstance) {
        this.fVMInstance = vmInstance;
    }

    protected String renderDebugTarget(String classToRun, int host) {
        String format = JamaicaPlugin.getResourceString("javaVMRunner.format.dbgTarget");
        return MessageFormat.format(format, classToRun, String.valueOf(host));
    }

    public static String renderProcessLabel(String[] commandLine) {
        String format = JamaicaPlugin.getResourceString("javaVMRunner.format.processLabel");
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine[0], timestamp);
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(' ');
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    protected void addArguments(String[] args, List v) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            v.add(args[i]);
            ++i;
        }
    }

    protected String getJDKLocation() {
        File location = this.fVMInstance.getInstallLocation();
        return location.getAbsolutePath();
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(MessageFormat.format(JamaicaPlugin.getResourceString("JavaVMRunner.Specified_working_directory_does_not_exist_or_is_not_a_directory__{0}_1"), path), null, 108);
        }
        return dir;
    }

    protected String getPluginIdentifier() {
        return JamaicaPlugin.getUniqueIdentifier();
    }

    protected Map getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "jamaimcavm");
        return map;
    }
}

