/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.jamaicavm;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.jamaicavm.JavaVMRunner;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JamaicaVMRunner
extends JavaVMRunner {
    public JamaicaVMRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] cp;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(JamaicaPlugin.getResourceString("JamaicaVMRunner.Launching_virtual_machine..._1"), 2);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaVMRunner.Constructing_command_line..._2"));
        File workingDir = this.getWorkingDir(config);
        String location = this.getJDKLocation();
        StringBuffer program = this.constructProgramString(location, config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program.toString());
        String[] bootCP = config.getBootClassPath();
        if (bootCP != null) {
            if (bootCP.length > 0) {
                arguments.add("-Xbootclasspath:" + this.convertClassPath(bootCP));
            } else {
                arguments.add("-Xbootclasspath:");
            }
        }
        if ((cp = config.getClassPath()).length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        String[] vmArgs = config.getVMArguments();
        this.addArguments(vmArgs, arguments);
        arguments.add(config.getClassToLaunch());
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaVMRunner.Starting_virtual_machine..._3"));
        Process p = this.exec(cmdLine, workingDir);
        if (p != null) {
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)JavaVMRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
            process.setAttribute(IProcess.ATTR_CMDLINE, JavaVMRunner.renderCommandLine(cmdLine));
        }
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected StringBuffer constructProgramString(String location, VMRunnerConfiguration config) {
        String command = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
        }
        StringBuffer program = new StringBuffer();
        program.append(location).append(File.separator).append("bin").append(File.separator);
        int directoryLength = program.length();
        if (command == null) {
            program.append("jamaicavm");
            File jamaicavm = new File(program.toString());
            if (!jamaicavm.exists()) {
                program.replace(directoryLength, program.length(), "jamaicavm");
            }
        } else {
            program.append(command);
        }
        return program;
    }

    protected String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cp.length) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
            ++i;
        }
        return buf.toString();
    }
}

