/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.jamaicavm;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMInstall;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.LibraryLocation;

public class JamaicaVMInstallType
extends AbstractVMInstallType {
    public static final String JamaicaVM_TYPE_ID = "com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMType";

    public IVMInstall doCreateVMInstall(String id) {
        return new JamaicaVMInstall((IVMInstallType)this, id);
    }

    public String getName() {
        return JamaicaPlugin.getResourceString("JamaicaVMType.name");
    }

    public IStatus validateInstallLocation(File installLocation) {
        File jamaicavm;
        String jamaicavmBinary = "jamaicavm";
        if (JamaicaPlugin.getDefault().getPreferenceStore().getString("OS").equals("Windows")) {
            jamaicavmBinary = "jamaicavm.exe";
        }
        if (!(jamaicavm = new File(installLocation, "bin" + File.separator + jamaicavmBinary)).isFile()) {
            return new Status(4, JamaicaPlugin.getUniqueIdentifier(), 0, JamaicaPlugin.getResourceString("JamaicaVMType.error.notRoot"), null);
        }
        return new Status(0, JamaicaPlugin.getUniqueIdentifier(), 0, "ok", null);
    }

    public File detectInstallLocation() {
        if (this.getName().equals(System.getProperty("java.vm.name"))) {
            return null;
        }
        File home = new File(System.getProperty("java.home"));
        IStatus status = this.validateInstallLocation(home);
        if (status.isOK()) {
            return home;
        }
        return null;
    }

    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        List extensions = this.getExtensionLibraries(installLocation);
        LibraryLocation[] libs = new LibraryLocation[extensions.size() + 1];
        Path libHome = new Path(installLocation.getPath());
        IPath lib = libHome.append("classes/jamaica-classes.jar");
        IPath source = libHome.append("source/source.zip");
        Path path = new Path("");
        libs[0] = new LibraryLocation(lib, source, (IPath)path);
        int i = 0;
        while (i < extensions.size()) {
            libs[i + 1] = (LibraryLocation)extensions.get(i);
            ++i;
        }
        return libs;
    }

    protected List getExtensionLibraries(File installLocation) {
        File extDir = this.getDefaultExtensionDirectory(installLocation);
        ArrayList<LibraryLocation> extensions = new ArrayList<LibraryLocation>();
        if (extDir != null && extDir.exists() && extDir.isDirectory()) {
            String[] names = extDir.list();
            int i = 0;
            while (i < names.length) {
                String suffix;
                int length;
                String name = names[i];
                File jar = new File(extDir, name);
                if (jar.isFile() && (length = name.length()) > 4 && ((suffix = name.substring(length - 4)).equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".jar"))) {
                    try {
                        Path libPath = new Path(jar.getCanonicalPath());
                        LibraryLocation library = new LibraryLocation((IPath)libPath, (IPath)Path.EMPTY, (IPath)Path.EMPTY);
                        extensions.add(library);
                    }
                    catch (IOException iOException) {}
                }
                ++i;
            }
        }
        return extensions;
    }

    protected File getDefaultExtensionDirectory(File installLocation) {
        File lib = new File(installLocation, "lib");
        File ext = new File(lib, "ext");
        return ext;
    }
}

