/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.jamaicavm;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMRunner;
import com.aicas.jamaica.eclipse.jamaicavm.JavaVMRunner;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JamaicaDebugVMRunner
extends JamaicaVMRunner {
    public JamaicaDebugVMRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] cp;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Launching_virtual_machine..._1"), 5);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Finding_free_socket..._2"));
        File workingDir = this.getWorkingDir(config);
        int port = SocketUtil.findUnusedLocalPort((String)"localhost", (int)1024, (int)65000);
        int proxyPort = SocketUtil.findUnusedLocalPort((String)"localhost", (int)1024, (int)65000);
        if (port == -1 || proxyPort == -1) {
            this.abort(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Could_not_find_a_free_socket_for_the_debugger_1"), null, 118);
        }
        subMonitor.worked(1);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Constructing_command_line..._3"));
        String location = this.getJDKLocation();
        StringBuffer program = this.constructProgramString(location, config);
        StringBuffer proxy = new StringBuffer(location);
        proxy.append(File.separator);
        proxy.append("bin");
        proxy.append(File.separator);
        proxy.append("jamaicavm");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program.toString());
        String[] bootCP = config.getBootClassPath();
        if (bootCP != null) {
            if (bootCP.length > 0) {
                arguments.add("-Xbootclasspath:" + this.convertClassPath(bootCP));
            } else {
                arguments.add("-Xbootclasspath:");
            }
        }
        if ((cp = config.getClassPath()).length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        this.addArguments(config.getVMArguments(), arguments);
        arguments.add("-debug:" + port);
        arguments.add(config.getClassToLaunch());
        this.addArguments(config.getProgramArguments(), arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] proxyCmd = new String[]{proxy.toString(), "localhost:" + port, Integer.toString(proxyPort)};
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Starting_virtual_machine..._4"));
        Process p = this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Starting_proxy..._5"));
        Process p2 = this.exec(proxyCmd, workingDir);
        if (p2 == null) {
            p.destroy();
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            p2.destroy();
            return;
        }
        IProcess process1 = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)JavaVMRunner.renderProcessLabel(cmdLine), (Map)this.getDefaultProcessMap());
        IProcess process2 = DebugPlugin.newProcess((ILaunch)launch, (Process)p2, (String)JavaVMRunner.renderProcessLabel(new String[]{"jamaicaProxy"}));
        process1.setAttribute(IProcess.ATTR_CMDLINE, JavaVMRunner.renderCommandLine(cmdLine));
        process2.setAttribute(IProcess.ATTR_CMDLINE, JavaVMRunner.renderCommandLine(proxyCmd));
        subMonitor.worked(1);
        subMonitor.subTask(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Establishing_debug_connection..._6"));
        AttachingConnector connector = this.getConnector();
        if (connector == null) {
            p.destroy();
            p2.destroy();
            this.abort(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Couldn__t_find_an_appropriate_debug_connector_2"), null, 119);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        this.specifyArguments(map, proxyPort);
        boolean retry = false;
        do {
            try {
                VirtualMachine vm;
                if (monitor.isCanceled()) {
                    p.destroy();
                    p2.destroy();
                    return;
                }
                try {
                    vm = connector.attach(map);
                }
                catch (IOException iOException) {
                    if (monitor.isCanceled()) {
                        p.destroy();
                        p2.destroy();
                        return;
                    }
                    vm = connector.attach(map);
                }
                JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)this.renderDebugTarget(config.getClassToLaunch(), port), (IProcess)process1, (boolean)true, (boolean)false);
                subMonitor.worked(1);
                subMonitor.done();
                return;
            }
            catch (IOException e) {
                String errorMessage = process1.getStreamsProxy().getErrorStreamMonitor().getContents();
                if (errorMessage.length() == 0) {
                    errorMessage = process2.getStreamsProxy().getErrorStreamMonitor().getContents();
                }
                if (errorMessage.length() != 0) {
                    this.abort(errorMessage, e, 116);
                    continue;
                }
                Status status = new Status(4, "org.eclipse.jdt.launching", 117, "", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                retry = false;
                if (handler == null) {
                    throw new CoreException((IStatus)status);
                }
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                if (!(result instanceof Boolean)) continue;
                retry = (Boolean)result;
            }
            catch (IllegalConnectorArgumentsException e) {
                retry = false;
                this.abort(JamaicaPlugin.getResourceString("JamaicaDebugVMRunner.Couldn__t_connect_to_VM_5"), e, 120);
            }
        } while (retry);
        p.destroy();
        p2.destroy();
    }

    protected AttachingConnector getConnector() {
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        int i = 0;
        while (i < connectors.size()) {
            AttachingConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketAttach".equals(c.name())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    protected void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
    }
}

