/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodFinder;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class JavaProjectTypes {
    private String mainClassName;
    private String programName;
    private static ILaunchConfigurationWorkingCopy currentConfig;
    static /* synthetic */ Class class$0;

    public void initializeProjectTypes(ILaunchConfigurationWorkingCopy config) {
        currentConfig = config;
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
            this.initializeMainTypeAndName(javaElement, config);
            this.initializeClasspathDestination(javaElement, config);
        } else {
            config.setAttribute("@projectName", "");
            config.setAttribute("@mainClassName", "");
            config.setAttribute("@programName", "a.out");
        }
    }

    public static void setCurrentConfig(ILaunchConfigurationWorkingCopy config) {
        currentConfig = config;
    }

    public static ILaunchConfigurationWorkingCopy getCurrentConfig() {
        return currentConfig;
    }

    public void initializeJavaProject(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String projectName = null;
        if (javaProject != null && javaProject.exists()) {
            projectName = javaProject.getElementName();
        }
        config.setAttribute("@projectName", projectName);
        String projectPath = javaProject.getProject().getLocation().toOSString();
        JavaProjectTypes.getCurrentConfig().setAttribute("@projectPath", projectPath);
    }

    public void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        try {
            IType[] types = MainMethodFinder.findTargets((IRunnableContext)new BusyIndicatorRunnableContext(), (Object[])new Object[]{javaElement});
            if (types != null && types.length > 0) {
                this.mainClassName = types[0].getFullyQualifiedName();
                this.programName = types[0].getElementName();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        config.setAttribute("@mainClassName", this.mainClassName);
        config.setAttribute("@programName", this.programName);
    }

    public void initializeClasspathDestination(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String projectBuildPaths = "";
        IClasspathEntry[] buildPaths = null;
        try {
            buildPaths = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            System.err.println("JamaicaPlugin: Error getting the project build paths");
        }
        int i = 1;
        while (i < buildPaths.length) {
            String buildPath = buildPaths[i].getPath().toOSString().trim();
            projectBuildPaths = String.valueOf(projectBuildPaths) + File.pathSeparatorChar + buildPath;
            ++i;
        }
        String outputLocation = "";
        try {
            outputLocation = javaProject.getOutputLocation().toOSString();
        }
        catch (JavaModelException javaModelException) {
            System.err.println("Jamaica Plugin: Error retrieving project output location");
        }
        int index = outputLocation.indexOf(File.separator, 1);
        outputLocation = index > 1 ? outputLocation.substring(index) : "";
        String projectPath = javaProject.getProject().getLocation().toOSString();
        String projectOutputPath = String.valueOf(projectPath) + outputLocation;
        config.setAttribute("@projectPath", projectPath);
        config.setAttribute("classpath", String.valueOf(projectOutputPath) + projectBuildPaths);
        config.setAttribute("classpath_state", "on");
        String destination = String.valueOf(projectPath) + File.separator + this.programName;
        if (new File(destination).isDirectory()) {
            destination = String.valueOf(projectPath) + File.separator + this.programName + File.separator + this.programName;
        }
        config.setAttribute("destination", destination.trim());
        config.setAttribute("destination_state", "on");
    }

    private IJavaElement getContext() {
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaElement) {
                    return (IJavaElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IJavaElement)input.getAdapter((Class)clazz);
            }
        }
        return null;
    }
}

