/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse;

import com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMInstall;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JamaicaPlugin
extends AbstractUIPlugin
implements IStartup {
    private static JamaicaPlugin plugin;
    private ResourceBundle resourceBundle;

    public JamaicaPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        if (JamaicaPlugin.getDefault().getPreferenceStore().getString("OS").equals("Windows")) {
            if (new File("C:\\Programs\\jamaica").exists()) {
                JamaicaPlugin.getDefault().getPreferenceStore().setDefault("JamaicaHome", "C:\\Programs\\jamaica");
            }
            if (new File("C:\\Programs\\expect\\expect.exe").isFile()) {
                JamaicaPlugin.getDefault().getPreferenceStore().setDefault("ExpectBinary", "C:\\Programs\\expect\\expect.exe");
            }
        } else {
            if (new File("/usr/local/jamaica").exists()) {
                JamaicaPlugin.getDefault().getPreferenceStore().setDefault("JamaicaHome", "/usr/local/jamaica");
            }
            if (new File("/usr/bin/expect").exists()) {
                JamaicaPlugin.getDefault().getPreferenceStore().setDefault("ExpectBinary", "/usr/bin/expect");
            }
        }
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("GLOBAL_OPTION_HINT_SHOW_PROMPT", true);
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("WARN_ON_RUNNING_TARGET_CONFIG", true);
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("WARN_ON_RUNNING_BUILDER_CONFIG", true);
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("WARN_ON_RUNNING_BUILDER_CONFIG", true);
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("BUILDER_IS_RUNNING", false);
        JamaicaPlugin.getDefault().getPreferenceStore().setDefault("TARGET_IS_RUNNING", false);
        try {
            this.resourceBundle = ResourceBundle.getBundle("plugin");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static JamaicaPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JamaicaPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (JamaicaPlugin.getDefault() == null) {
            return "com.aicas.jamaica.eclipse";
        }
        return JamaicaPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public void earlyStartup() {
        if (System.getProperty("os.name").toLowerCase().startsWith("microsoft") || System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            JamaicaPlugin.getDefault().getPreferenceStore().setValue("OS", "Windows");
        }
        JamaicaVMInstall.addJamaicaVM();
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        if (!defaultVM.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMType") && !JamaicaPlugin.getDefault().getPreferenceStore().getBoolean("askedToSetJamaicaVMToDefault")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openQuestion((Shell)new Shell(), (String)"JamaicaVM Plugin", (String)JamaicaPlugin.getResourceString("Question_SetJamaicaVMtoStandardJRE"))) {
                        IVMInstall jamaicaVM = JavaRuntime.getVMInstallType((String)"com.aicas.jamaica.eclipse.jamaicavm.JamaicaVMType").getVMInstalls()[0];
                        try {
                            JavaRuntime.setDefaultVMInstall((IVMInstall)jamaicaVM, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            JamaicaPlugin.getDefault().getPreferenceStore().setValue("askedToSetJamaicaVMToDefault", true);
        }
    }
}

