/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class JamaicaConfSettings {
    private Properties jamaicaConf = new Properties();

    public JamaicaConfSettings() {
        String filename = "";
        String jamaicaHome = JamaicaPlugin.getDefault().getPreferenceStore().getString("JamaicaHome");
        filename = !jamaicaHome.endsWith(File.separator) ? String.valueOf(jamaicaHome) + File.separator + "etc" + File.separator + "jamaica.conf" : String.valueOf(jamaicaHome) + "etc" + File.separator + "jamaica.conf";
        FileInputStream cfgstream = null;
        String userConf = String.valueOf(System.getProperty("user.home")) + File.separator + ".jamaica" + File.separator + "jamaica.conf";
        if (new File(userConf).exists()) {
            filename = userConf;
        }
        try {
            cfgstream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Jamacia Plugin: Error loading " + (filename.equals("") ? "jamaica.conf" : filename));
            MessageDialog.openError((Shell)new Shell(), (String)"Jamaica Builder", (String)JamaicaPlugin.getResourceString("ErrorMessage_OpeningConfigFile"));
        }
        try {
            this.jamaicaConf.load(cfgstream);
            cfgstream.close();
        }
        catch (IOException iOException) {
            System.err.println("Jamacia Plugin: Error loading properties from " + filename);
            MessageDialog.openError((Shell)new Shell(), (String)"Jamaica Builder", (String)JamaicaPlugin.getResourceString("ErrorMessage_LoadingPropertyFile"));
        }
    }

    public String getAttribute(String key) {
        return this.jamaicaConf.getProperty(key, "").trim();
    }

    public Map getDefaultsMap() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Enumeration<?> keys = this.jamaicaConf.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.jamaicaConf.getProperty(key).trim();
            map.put(key, value);
            if (value.length() > 0) {
                map.put(String.valueOf(key) + "_state", "on");
                continue;
            }
            map.put(String.valueOf(key) + "_state", "off");
        }
        map.put("target", "host");
        return map;
    }
}

